/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.neo4j.shaded.lucene9.index.ByteVectorValues;
import org.neo4j.shaded.lucene9.index.FieldInfo;
import org.neo4j.shaded.lucene9.index.LeafReader;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.search.AbstractKnnVectorQuery;
import org.neo4j.shaded.lucene9.search.KnnCollector;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.TopDocs;
import org.neo4j.shaded.lucene9.search.TopDocsCollector;
import org.neo4j.shaded.lucene9.search.VectorScorer;
import org.neo4j.shaded.lucene9.search.knn.KnnCollectorManager;
import org.neo4j.shaded.lucene9.util.ArrayUtil;
import org.neo4j.shaded.lucene9.util.Bits;

public class KnnByteVectorQuery
extends AbstractKnnVectorQuery {
    private static final TopDocs NO_RESULTS = TopDocsCollector.EMPTY_TOPDOCS;
    private final byte[] target;

    public KnnByteVectorQuery(String field, byte[] target, int k) {
        this(field, target, k, null);
    }

    public KnnByteVectorQuery(String field, byte[] target, int k, Query filter) {
        super(field, k, filter);
        this.target = Objects.requireNonNull(target, "target");
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitedLimit, KnnCollectorManager knnCollectorManager) throws IOException {
        KnnCollector knnCollector = knnCollectorManager.newCollector(visitedLimit, context);
        LeafReader reader = context.reader();
        ByteVectorValues byteVectorValues = reader.getByteVectorValues(this.field);
        if (byteVectorValues == null) {
            ByteVectorValues.checkField(reader, this.field);
            return NO_RESULTS;
        }
        if (Math.min(knnCollector.k(), byteVectorValues.size()) == 0) {
            return NO_RESULTS;
        }
        reader.searchNearestVectors(this.field, this.target, knnCollector, acceptDocs);
        TopDocs results = knnCollector.topDocs();
        return results != null ? results : NO_RESULTS;
    }

    @Override
    VectorScorer createVectorScorer(LeafReaderContext context, FieldInfo fi) throws IOException {
        LeafReader reader = context.reader();
        ByteVectorValues vectorValues = reader.getByteVectorValues(this.field);
        if (vectorValues == null) {
            ByteVectorValues.checkField(reader, this.field);
            return null;
        }
        return vectorValues.scorer(this.target);
    }

    @Override
    public String toString(String field) {
        return this.getClass().getSimpleName() + ":" + this.field + "[" + this.target[0] + ",...][" + this.k + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        KnnByteVectorQuery that = (KnnByteVectorQuery)o;
        return Arrays.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.target));
    }

    public byte[] getTargetCopy() {
        return ArrayUtil.copyArray(this.target);
    }
}

