/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search;

import java.io.IOException;
import org.neo4j.shaded.lucene9.index.IndexReader;
import org.neo4j.shaded.lucene9.index.Term;
import org.neo4j.shaded.lucene9.index.TermState;
import org.neo4j.shaded.lucene9.index.TermStates;
import org.neo4j.shaded.lucene9.index.TermsEnum;
import org.neo4j.shaded.lucene9.search.BooleanClause;
import org.neo4j.shaded.lucene9.search.BooleanQuery;
import org.neo4j.shaded.lucene9.search.BoostAttribute;
import org.neo4j.shaded.lucene9.search.BoostQuery;
import org.neo4j.shaded.lucene9.search.ConstantScoreQuery;
import org.neo4j.shaded.lucene9.search.IndexSearcher;
import org.neo4j.shaded.lucene9.search.MultiTermQuery;
import org.neo4j.shaded.lucene9.search.Query;
import org.neo4j.shaded.lucene9.search.TermCollectingRewrite;
import org.neo4j.shaded.lucene9.search.TermQuery;
import org.neo4j.shaded.lucene9.util.ArrayUtil;
import org.neo4j.shaded.lucene9.util.ByteBlockPool;
import org.neo4j.shaded.lucene9.util.BytesRef;
import org.neo4j.shaded.lucene9.util.BytesRefHash;
import org.neo4j.shaded.lucene9.util.RamUsageEstimator;

public abstract class ScoringRewrite<B>
extends TermCollectingRewrite<B> {
    public static final ScoringRewrite<BooleanQuery.Builder> SCORING_BOOLEAN_REWRITE = new ScoringRewrite<BooleanQuery.Builder>(){

        @Override
        protected BooleanQuery.Builder getTopLevelBuilder() {
            return new BooleanQuery.Builder();
        }

        @Override
        protected Query build(BooleanQuery.Builder builder) {
            return builder.build();
        }

        @Override
        protected void addClause(BooleanQuery.Builder topLevel, Term term, int docCount, float boost, TermStates states) {
            TermQuery tq = new TermQuery(term, states);
            topLevel.add(new BoostQuery(tq, boost), BooleanClause.Occur.SHOULD);
        }

        @Override
        protected void checkMaxClauseCount(int count) {
            if (count > IndexSearcher.getMaxClauseCount()) {
                throw new IndexSearcher.TooManyClauses();
            }
        }
    };
    public static final MultiTermQuery.RewriteMethod CONSTANT_SCORE_BOOLEAN_REWRITE = new MultiTermQuery.RewriteMethod(){

        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            Query bq = SCORING_BOOLEAN_REWRITE.rewrite(reader, query);
            return new ConstantScoreQuery(bq);
        }
    };

    protected abstract void checkMaxClauseCount(int var1) throws IOException;

    @Override
    public final Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
        Object builder = this.getTopLevelBuilder();
        ParallelArraysTermCollector col = new ParallelArraysTermCollector();
        this.collectTerms(reader, query, col);
        int size = col.terms.size();
        if (size > 0) {
            int[] sort = col.terms.sort();
            float[] boost = col.array.boost;
            TermStates[] termStates = col.array.termState;
            for (int i = 0; i < size; ++i) {
                int pos = sort[i];
                Term term = new Term(query.getField(), col.terms.get(pos, new BytesRef()));
                assert (reader.docFreq(term) == termStates[pos].docFreq());
                this.addClause(builder, term, termStates[pos].docFreq(), boost[pos], termStates[pos]);
            }
        }
        return this.build(builder);
    }

    static final class TermFreqBoostByteStart
    extends BytesRefHash.DirectBytesStartArray {
        float[] boost;
        TermStates[] termState;

        public TermFreqBoostByteStart(int initSize) {
            super(initSize);
        }

        @Override
        public int[] init() {
            int[] ord = super.init();
            this.boost = new float[ArrayUtil.oversize(ord.length, 4)];
            this.termState = new TermStates[ArrayUtil.oversize(ord.length, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            assert (this.termState.length >= ord.length && this.boost.length >= ord.length);
            return ord;
        }

        @Override
        public int[] grow() {
            int[] ord = super.grow();
            this.boost = ArrayUtil.grow(this.boost, ord.length);
            if (this.termState.length < ord.length) {
                TermStates[] tmpTermState = new TermStates[ArrayUtil.oversize(ord.length, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.termState, 0, tmpTermState, 0, this.termState.length);
                this.termState = tmpTermState;
            }
            assert (this.termState.length >= ord.length && this.boost.length >= ord.length);
            return ord;
        }

        @Override
        public int[] clear() {
            this.boost = null;
            this.termState = null;
            return super.clear();
        }
    }

    final class ParallelArraysTermCollector
    extends TermCollectingRewrite.TermCollector {
        final TermFreqBoostByteStart array = new TermFreqBoostByteStart(16);
        final BytesRefHash terms = new BytesRefHash(new ByteBlockPool(new ByteBlockPool.DirectAllocator()), 16, this.array);
        TermsEnum termsEnum;
        private BoostAttribute boostAtt;

        ParallelArraysTermCollector() {
        }

        @Override
        public void setNextEnum(TermsEnum termsEnum) {
            this.termsEnum = termsEnum;
            this.boostAtt = termsEnum.attributes().addAttribute(BoostAttribute.class);
        }

        @Override
        public boolean collect(BytesRef bytes) throws IOException {
            int e = this.terms.add(bytes);
            TermState state = this.termsEnum.termState();
            assert (state != null);
            if (e < 0) {
                int pos = -e - 1;
                this.array.termState[pos].register(state, this.readerContext.ord, this.termsEnum.docFreq(), this.termsEnum.totalTermFreq());
                assert (this.array.boost[pos] == this.boostAtt.getBoost()) : "boost should be equal in all segment TermsEnums";
            } else {
                this.array.boost[e] = this.boostAtt.getBoost();
                this.array.termState[e] = new TermStates(this.topReaderContext, state, this.readerContext.ord, this.termsEnum.docFreq(), this.termsEnum.totalTermFreq());
                ScoringRewrite.this.checkMaxClauseCount(this.terms.size());
            }
            return true;
        }
    }
}

