/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.search.knn;

import java.io.IOException;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.search.IndexSearcher;
import org.neo4j.shaded.lucene9.search.KnnCollector;
import org.neo4j.shaded.lucene9.search.TopKnnCollector;
import org.neo4j.shaded.lucene9.search.knn.KnnCollectorManager;
import org.neo4j.shaded.lucene9.search.knn.MultiLeafKnnCollector;
import org.neo4j.shaded.lucene9.util.hnsw.BlockingFloatHeap;

public class TopKnnCollectorManager
implements KnnCollectorManager {
    private final int k;
    private final BlockingFloatHeap globalScoreQueue;

    public TopKnnCollectorManager(int k, IndexSearcher indexSearcher) {
        boolean isMultiSegments = indexSearcher.getIndexReader().leaves().size() > 1;
        this.k = k;
        this.globalScoreQueue = isMultiSegments ? new BlockingFloatHeap(k) : null;
    }

    @Override
    public KnnCollector newCollector(int visitedLimit, LeafReaderContext context) throws IOException {
        if (this.globalScoreQueue == null) {
            return new TopKnnCollector(this.k, visitedLimit);
        }
        return new MultiLeafKnnCollector(this.k, this.globalScoreQueue, new TopKnnCollector(this.k, visitedLimit));
    }
}

