/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shaded.lucene9.util.hnsw;

import java.io.IOException;
import org.neo4j.shaded.lucene9.codecs.hnsw.HnswGraphProvider;
import org.neo4j.shaded.lucene9.index.FieldInfo;
import org.neo4j.shaded.lucene9.search.DocIdSetIterator;
import org.neo4j.shaded.lucene9.search.TaskExecutor;
import org.neo4j.shaded.lucene9.util.FixedBitSet;
import org.neo4j.shaded.lucene9.util.hnsw.HnswBuilder;
import org.neo4j.shaded.lucene9.util.hnsw.HnswConcurrentMergeBuilder;
import org.neo4j.shaded.lucene9.util.hnsw.HnswGraph;
import org.neo4j.shaded.lucene9.util.hnsw.IncrementalHnswGraphMerger;
import org.neo4j.shaded.lucene9.util.hnsw.InitializedHnswGraphBuilder;
import org.neo4j.shaded.lucene9.util.hnsw.OnHeapHnswGraph;
import org.neo4j.shaded.lucene9.util.hnsw.RandomVectorScorerSupplier;

public class ConcurrentHnswMerger
extends IncrementalHnswGraphMerger {
    private final TaskExecutor taskExecutor;
    private final int numWorker;

    public ConcurrentHnswMerger(FieldInfo fieldInfo, RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, TaskExecutor taskExecutor, int numWorker) {
        super(fieldInfo, scorerSupplier, M, beamWidth);
        this.taskExecutor = taskExecutor;
        this.numWorker = numWorker;
    }

    @Override
    protected HnswBuilder createBuilder(DocIdSetIterator mergedVectorIterator, int maxOrd) throws IOException {
        if (this.initReader == null) {
            return new HnswConcurrentMergeBuilder(this.taskExecutor, this.numWorker, this.scorerSupplier, this.M, this.beamWidth, new OnHeapHnswGraph(this.M, maxOrd), null);
        }
        HnswGraph initializerGraph = ((HnswGraphProvider)((Object)this.initReader)).getGraph(this.fieldInfo.name);
        FixedBitSet initializedNodes = new FixedBitSet(maxOrd);
        int[] oldToNewOrdinalMap = this.getNewOrdMapping(mergedVectorIterator, initializedNodes);
        return new HnswConcurrentMergeBuilder(this.taskExecutor, this.numWorker, this.scorerSupplier, this.M, this.beamWidth, InitializedHnswGraphBuilder.initGraph(this.M, initializerGraph, oldToNewOrdinalMap, maxOrd), initializedNodes);
    }
}

