/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.v3_5.ast.semantics;

import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticError;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticExpressionCheck$;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticFunSuite;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticState$;
import org.neo4j.cypher.internal.v3_5.expressions.ContainerIndex;
import org.neo4j.cypher.internal.v3_5.expressions.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.v3_5.expressions.DummyExpression;
import org.neo4j.cypher.internal.v3_5.expressions.DummyExpression$;
import org.neo4j.cypher.internal.v3_5.expressions.Expression;
import org.neo4j.cypher.internal.v3_5.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.v3_5.util.DummyPosition$;
import org.neo4j.cypher.internal.v3_5.util.InputPosition;
import org.neo4j.cypher.internal.v3_5.util.symbols.CypherType;
import org.neo4j.cypher.internal.v3_5.util.symbols.TypeSpec;
import org.neo4j.cypher.internal.v3_5.util.symbols.TypeSpec$;
import org.neo4j.cypher.internal.v3_5.util.symbols.package$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001#\t\u00112i\u001c8uC&tWM]%oI\u0016DH+Z:u\u0015\t\u0019A!A\u0005tK6\fg\u000e^5dg*\u0011QAB\u0001\u0004CN$(BA\u0004\t\u0003\u001118gX\u001b\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0011'\u0016l\u0017M\u001c;jG\u001a+hnU;ji\u0016DQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005M\u0001\u0001bB\u000e\u0001\u0005\u0004%\t\u0001H\u0001\fIVlW._*ue&tw-F\u0001\u001e!\tq\u0012%D\u0001 \u0015\t\u0001c!A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u0001\u0012 \u0005=!U/\\7z\u000bb\u0004(/Z:tS>t\u0007B\u0002\u0013\u0001A\u0003%Q$\u0001\u0007ek6l\u0017p\u0015;sS:<\u0007\u0005C\u0004'\u0001\t\u0007I\u0011\u0001\u000f\u0002\u0019\u0011,X.\\=J]R,w-\u001a:\t\r!\u0002\u0001\u0015!\u0003\u001e\u00035!W/\\7z\u0013:$XmZ3sA!9!\u0006\u0001b\u0001\n\u0003a\u0012!\u00033v[6Lhj\u001c3f\u0011\u0019a\u0003\u0001)A\u0005;\u0005QA-^7ns:{G-\u001a\u0011\t\u000f9\u0002!\u0019!C\u00019\u0005AA-^7ns\u0006s\u0017\u0010\u0003\u00041\u0001\u0001\u0006I!H\u0001\nIVlW._!os\u0002BqA\r\u0001C\u0002\u0013\u0005A$A\u0005ek6l\u0017\u0010T5ti\"1A\u0007\u0001Q\u0001\nu\t!\u0002Z;n[fd\u0015n\u001d;!\u0011\u00151\u0004\u0001\"\u00038\u00031\t7o]3si&\u001bH*[:u)\tAd\b\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$H\u0001\u0003V]&$\b\"B 6\u0001\u0004\u0001\u0015\u0001B:qK\u000e\u0004\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u000fMLXNY8mg*\u0011QIB\u0001\u0005kRLG.\u0003\u0002H\u0005\nAA+\u001f9f'B,7\rC\u0003J\u0001\u0011%!*A\u0006bgN,'\u000f^%t\u001b\u0006\u0004HC\u0001\u001dL\u0011\u0015y\u0004\n1\u0001A\u0001")
public class ContainerIndexTest
extends SemanticFunSuite {
    private final DummyExpression dummyString = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTString()), DummyExpression$.MODULE$.apply$default$2());
    private final DummyExpression dummyInteger = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTInteger()), DummyExpression$.MODULE$.apply$default$2());
    private final DummyExpression dummyNode = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), DummyExpression$.MODULE$.apply$default$2());
    private final DummyExpression dummyAny = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTAny()), DummyExpression$.MODULE$.apply$default$2());
    private final DummyExpression dummyList = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()))), DummyExpression$.MODULE$.apply$default$2());

    public DummyExpression dummyString() {
        return this.dummyString;
    }

    public DummyExpression dummyInteger() {
        return this.dummyInteger;
    }

    public DummyExpression dummyNode() {
        return this.dummyNode;
    }

    public DummyExpression dummyAny() {
        return this.dummyAny;
    }

    public DummyExpression dummyList() {
        return this.dummyList;
    }

    public void org$neo4j$cypher$internal$v3_5$ast$semantics$ContainerIndexTest$$assertIsList(TypeSpec spec) {
        TypeSpec intersection;
        TypeSpec typeSpec = intersection = spec.$amp(package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()).covariant());
        TypeSpec typeSpec2 = TypeSpec$.MODULE$.none();
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((!(typeSpec != null ? !typeSpec.equals(typeSpec2) : typeSpec2 != null) ? 1 : 0) != 0)).should(this.be().apply(false));
        this.convertToAnyShouldWrapper(spec).should(this.equal(intersection), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$v3_5$ast$semantics$ContainerIndexTest$$assertIsMap(TypeSpec spec) {
        TypeSpec intersection;
        TypeSpec typeSpec = intersection = spec.$amp(package$.MODULE$.CTMap().covariant());
        TypeSpec typeSpec2 = TypeSpec$.MODULE$.none();
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((!(typeSpec != null ? !typeSpec.equals(typeSpec2) : typeSpec2 != null) ? 1 : 0) != 0)).should(this.be().apply(false));
        this.convertToAnyShouldWrapper(spec).should(this.equal(intersection), (Object)Equality$.MODULE$.default());
    }

    public ContainerIndexTest() {
        this.test("should detect list lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyExpression lhs = this.$outer.dummyList();
                DummyExpression rhs = this.$outer.dummyInteger();
                ContainerIndex index = new ContainerIndex((Expression)lhs, (Expression)rhs, DummyPosition$.MODULE$.apply(10));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)index).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$ContainerIndexTest$$assertIsList((TypeSpec)this.$outer.types((Expression)lhs).apply((Object)result.state()));
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)rhs).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.CTInteger().covariant()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)index).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTString()))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should detect node lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyExpression lhs = this.$outer.dummyNode();
                DummyExpression rhs = this.$outer.dummyString();
                ContainerIndex index = new ContainerIndex((Expression)lhs, (Expression)rhs, DummyPosition$.MODULE$.apply(10));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)index).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$ContainerIndexTest$$assertIsMap((TypeSpec)this.$outer.types((Expression)lhs).apply((Object)result.state()));
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)rhs).apply((Object)result.state())).should(this.$outer.equal(((CypherType)package$.MODULE$.CTString()).covariant()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)index).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.CTAny().covariant()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should type as any if given untyped lookup arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyExpression lhs = this.$outer.dummyAny();
                DummyExpression rhs = this.$outer.dummyAny();
                ContainerIndex index = new ContainerIndex((Expression)lhs, (Expression)rhs, DummyPosition$.MODULE$.apply(10));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)index).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)lhs).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.CTAny().contravariant()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)rhs).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.CTAny().contravariant()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)index).apply((Object)result.state())).should(this.$outer.equal(TypeSpec$.MODULE$.all()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return list inner types of expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ContainerIndex index = new ContainerIndex((Expression)this.$outer.dummyList(), (Expression)new SignedDecimalIntegerLiteral("1", DummyPosition$.MODULE$.apply(5)), DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)index).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)index).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTString()))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should raise error if indexing by fraction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ContainerIndex index = new ContainerIndex((Expression)this.$outer.dummyList(), (Expression)new DecimalDoubleLiteral("1.3", DummyPosition$.MODULE$.apply(5)), DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)index).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("Type mismatch: expected Integer but was Float", index.idx().position(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

