/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.v3_5.ast.semantics;

import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticError;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticExpressionCheck$;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticFunSuite;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticState$;
import org.neo4j.cypher.internal.v3_5.expressions.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.v3_5.expressions.DummyExpression;
import org.neo4j.cypher.internal.v3_5.expressions.DummyExpression$;
import org.neo4j.cypher.internal.v3_5.expressions.Expression;
import org.neo4j.cypher.internal.v3_5.expressions.ListSlice;
import org.neo4j.cypher.internal.v3_5.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.v3_5.util.DummyPosition$;
import org.neo4j.cypher.internal.v3_5.util.InputPosition;
import org.neo4j.cypher.internal.v3_5.util.symbols.CypherType;
import org.neo4j.cypher.internal.v3_5.util.symbols.package$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00152A!\u0001\u0002\u0001#\tiA*[:u'2L7-\u001a+fgRT!a\u0001\u0003\u0002\u0013M,W.\u00198uS\u000e\u001c(BA\u0003\u0007\u0003\r\t7\u000f\u001e\u0006\u0003\u000f!\tAA^\u001a`k)\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00055q\u0011!\u00028f_RR'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005A\u0019V-\\1oi&\u001cg)\u001e8Tk&$X\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u00111\u0003\u0001\u0005\b7\u0001\u0011\r\u0011\"\u0001\u001d\u0003%!W/\\7z\u0019&\u001cH/F\u0001\u001e!\tq\u0012%D\u0001 \u0015\t\u0001c!A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u0001\u0012 \u0005=!U/\\7z\u000bb\u0004(/Z:tS>t\u0007B\u0002\u0013\u0001A\u0003%Q$\u0001\u0006ek6l\u0017\u0010T5ti\u0002\u0002")
public class ListSliceTest
extends SemanticFunSuite {
    private final DummyExpression dummyList = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()))), DummyExpression$.MODULE$.apply$default$2());

    public DummyExpression dummyList() {
        return this.dummyList;
    }

    public ListSliceTest() {
        this.test("shouldReturnCollectionTypesOfExpression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ListSliceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ListSlice slice = new ListSlice((Expression)this.$outer.dummyList(), (Option)new Some((Object)new SignedDecimalIntegerLiteral("1", DummyPosition$.MODULE$.apply(5))), (Option)new Some((Object)new SignedDecimalIntegerLiteral("2", DummyPosition$.MODULE$.apply(7))), DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)slice).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)slice).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString())))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldRaiseErrorWhenNeitherFromOrTwoSpecified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ListSliceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ListSlice slice = new ListSlice((Expression)this.$outer.dummyList(), (Option)None$.MODULE$, (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)slice).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("The start or end (or both) is required for a collection slice", slice.position(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldRaiseErrorIfStartingFromFraction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ListSliceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecimalDoubleLiteral to = new DecimalDoubleLiteral("1.3", DummyPosition$.MODULE$.apply(5));
                ListSlice slice = new ListSlice((Expression)this.$outer.dummyList(), (Option)None$.MODULE$, (Option)new Some((Object)to), DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)slice).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("Type mismatch: expected Integer but was Float", to.position(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

