/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.v3_5.ast.semantics;

import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticError;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticExpressionCheck$;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticFunSuite;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticState$;
import org.neo4j.cypher.internal.v3_5.expressions.Expression;
import org.neo4j.cypher.internal.v3_5.expressions.Literal;
import org.neo4j.cypher.internal.v3_5.expressions.StringLiteral;
import org.neo4j.cypher.internal.v3_5.expressions.UnsignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.v3_5.util.InputPosition;
import org.neo4j.cypher.internal.v3_5.util.symbols.CypherType;
import org.neo4j.cypher.internal.v3_5.util.symbols.TypeSpec;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q2A!\u0001\u0002\u0001#\tYA*\u001b;fe\u0006dG+Z:u\u0015\t\u0019A!A\u0005tK6\fg\u000e^5dg*\u0011QAB\u0001\u0004CN$(BA\u0004\t\u0003\u001118gX\u001b\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0011'\u0016l\u0017M\u001c;jG\u001a+hnU;ji\u0016DQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005M\u0001\u0001\"B\u000e\u0001\t\u0013a\u0012aE1tg\u0016\u0014HoU3nC:$\u0018nY#se>\u0014HcA\u000f$WA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t!QK\\5u\u0011\u0015!#\u00041\u0001&\u0003\u001da\u0017\u000e^3sC2\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u0004\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003U\u001d\u0012q\u0001T5uKJ\fG\u000eC\u0003-5\u0001\u0007Q&\u0001\u0007feJ|'/T3tg\u0006<W\r\u0005\u0002/c9\u0011adL\u0005\u0003a}\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001g\b")
public class LiteralTest
extends SemanticFunSuite {
    public void org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError(Literal literal, String errorMessage) {
        SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)literal).apply((Object)SemanticState$.MODULE$.clean());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result.errors());
        Vector $org_scalatest_assert_macro_right = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError(errorMessage, this.pos(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public LiteralTest() {
        this.test("has type CTString", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StringLiteral literal = new StringLiteral("foo", this.$outer.pos());
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)literal).apply((Object)SemanticState$.MODULE$.clean());
                TypeSpec expressionType = result.state().expressionType((Expression)literal).actual();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(expressionType);
                TypeSpec $org_scalatest_assert_macro_right = ((CypherType)org.neo4j.cypher.internal.v3_5.util.symbols.package$.MODULE$.CTString()).invariant();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly parses unsigned decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new UnsignedDecimalIntegerLiteral("22", this.$outer.pos()).value());
                int $org_scalatest_assert_macro_right = 22;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(new UnsignedDecimalIntegerLiteral("0", this.$outer.pos()).value());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid unsigned decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.unsignedDecimal("12g3"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.unsignedDecimal("923_23"), "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large unsigned decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.unsignedDecimal("999999999999999999999999999"), "integer is too large");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly parses signed decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.signedDecimal("22").value());
                int $org_scalatest_assert_macro_right = 22;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.$outer.signedDecimal("0").value());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.$outer.signedDecimal("-0").value());
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(this.$outer.signedDecimal("-432").value());
                int $org_scalatest_assert_macro_right4 = -432;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid signed decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedDecimal("12g3"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedDecimal("923_23"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedDecimal("-92f3"), "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large signed decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedDecimal("999999999999999999999999999"), "integer is too large");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly parses decimal double numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.decimalDouble("22.34").value());
                double $org_scalatest_assert_macro_right = 22.34;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-2342.34").value());
                double $org_scalatest_assert_macro_right2 = -2342.34;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("0.34").value());
                double $org_scalatest_assert_macro_right3 = 0.34;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-.23").value());
                double $org_scalatest_assert_macro_right4 = -0.23;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("0.0").value());
                double $org_scalatest_assert_macro_right5 = 0.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-0.0").value());
                double $org_scalatest_assert_macro_right6 = 0.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("1E23").value());
                double $org_scalatest_assert_macro_right7 = 1.0E23;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("1e23").value());
                double $org_scalatest_assert_macro_right8 = 1.0E23;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-134E233").value());
                double $org_scalatest_assert_macro_right9 = -1.34E235;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-134e233").value());
                double $org_scalatest_assert_macro_right10 = -1.34E235;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("1E-99").value());
                double $org_scalatest_assert_macro_right11 = 1.0E-99;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("1e-99").value());
                double $org_scalatest_assert_macro_right12 = 1.0E-99;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-4E-593").value());
                double $org_scalatest_assert_macro_right13 = -0.0;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-4e-593").value());
                double $org_scalatest_assert_macro_right14 = -0.0;
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("3.42E34").value());
                double $org_scalatest_assert_macro_right15 = 3.42E34;
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right15), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("3.42e34").value());
                double $org_scalatest_assert_macro_right16 = 3.42E34;
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right16), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-65.342546547E33").value());
                double $org_scalatest_assert_macro_right17 = -6.5342546547E34;
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right17), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-65.342546547e33").value());
                double $org_scalatest_assert_macro_right18 = -6.5342546547E34;
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right18), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("73.234E-235").value());
                double $org_scalatest_assert_macro_right19 = 7.3234E-234;
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right19), $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right19), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left20 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("73.234e-235").value());
                double $org_scalatest_assert_macro_right20 = 7.3234E-234;
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right20), $org_scalatest_assert_macro_left20.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right20), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left21 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-73.234E-235").value());
                double $org_scalatest_assert_macro_right21 = -7.3234E-234;
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right21), $org_scalatest_assert_macro_left21.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right21), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left22 = this.$outer.convertToEqualizer(this.$outer.decimalDouble("-73.234e-235").value());
                double $org_scalatest_assert_macro_right22 = -7.3234E-234;
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left22, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right22), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid decimal double numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("33..34"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("3f.34"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("3._4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2EE4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2eE4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2Ee4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2ee4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2E--4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2e--4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2E"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2e"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2..3E34"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("2..3e34"), "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large decimal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("1E9999"), "floating point number is too large");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.decimalDouble("1e9999"), "floating point number is too large");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly parses octal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.signedOctal("022").value());
                int $org_scalatest_assert_macro_right = 18;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.$outer.signedOctal("00").value());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.$outer.signedOctal("0734").value());
                int $org_scalatest_assert_macro_right3 = 476;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(this.$outer.signedOctal("0034").value());
                int $org_scalatest_assert_macro_right4 = 28;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid octal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedOctal("0393"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedOctal("03f4"), "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedOctal("-0934"), "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large octal numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$v3_5$ast$semantics$LiteralTest$$assertSemanticError((Literal)this.$outer.signedOctal("077777777777777777777777777777"), "integer is too large");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

