/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.v3_5.ast.semantics;

import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticCheckResult;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticError;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticExpressionCheck$;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticFunSuite;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.v3_5.ast.semantics.SemanticState$;
import org.neo4j.cypher.internal.v3_5.expressions.Expression;
import org.neo4j.cypher.internal.v3_5.expressions.LogicalVariable;
import org.neo4j.cypher.internal.v3_5.expressions.NodePattern;
import org.neo4j.cypher.internal.v3_5.expressions.NodePattern$;
import org.neo4j.cypher.internal.v3_5.expressions.PatternComprehension;
import org.neo4j.cypher.internal.v3_5.expressions.PatternElement;
import org.neo4j.cypher.internal.v3_5.expressions.Property;
import org.neo4j.cypher.internal.v3_5.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.v3_5.expressions.RelationshipChain;
import org.neo4j.cypher.internal.v3_5.expressions.RelationshipPattern;
import org.neo4j.cypher.internal.v3_5.expressions.RelationshipPattern$;
import org.neo4j.cypher.internal.v3_5.expressions.RelationshipsPattern;
import org.neo4j.cypher.internal.v3_5.expressions.SemanticDirection;
import org.neo4j.cypher.internal.v3_5.expressions.StringLiteral;
import org.neo4j.cypher.internal.v3_5.util.InputPosition;
import org.neo4j.cypher.internal.v3_5.util.symbols.CypherType;
import org.neo4j.cypher.internal.v3_5.util.symbols.package$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001#\tA\u0002+\u0019;uKJt7i\\7qe\u0016DWM\\:j_:$Vm\u001d;\u000b\u0005\r!\u0011!C:f[\u0006tG/[2t\u0015\t)a!A\u0002bgRT!a\u0002\u0005\u0002\tY\u001ct,\u000e\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\tTK6\fg\u000e^5d\rVt7+^5uK\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u0003'\u0001Aqa\u0007\u0001C\u0002\u0013\u0005A$A\u0001o+\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0007\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005\tz\"a\u0003(pI\u0016\u0004\u0016\r\u001e;fe:Da\u0001\n\u0001!\u0002\u0013i\u0012A\u00018!\u0011\u001d1\u0003A1A\u0005\u0002q\t\u0011\u0001\u001f\u0005\u0007Q\u0001\u0001\u000b\u0011B\u000f\u0002\u0005a\u0004\u0003b\u0002\u0016\u0001\u0005\u0004%\taK\u0001\u0002eV\tA\u0006\u0005\u0002\u001f[%\u0011af\b\u0002\u0014%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d)biR,'O\u001c\u0005\u0007a\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u0005I\u0004\u0003b\u0002\u001a\u0001\u0005\u0004%\taM\u0001\ba\u0006$H/\u001a:o+\u0005!\u0004C\u0001\u00106\u0013\t1tD\u0001\u000bSK2\fG/[8og\"L\u0007o\u001d)biR,'O\u001c\u0005\u0007q\u0001\u0001\u000b\u0011\u0002\u001b\u0002\u0011A\fG\u000f^3s]\u0002BqA\u000f\u0001C\u0002\u0013\u00051(\u0001\u0005qe>\u0004XM\u001d;z+\u0005a\u0004C\u0001\u0010>\u0013\tqtD\u0001\u0005Qe>\u0004XM\u001d;z\u0011\u0019\u0001\u0005\u0001)A\u0005y\u0005I\u0001O]8qKJ$\u0018\u0010\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001<\u0003=1\u0017-\u001b7j]\u001e\u0004&o\u001c9feRL\bB\u0002#\u0001A\u0003%A(\u0001\tgC&d\u0017N\\4Qe>\u0004XM\u001d;zA!9a\t\u0001b\u0001\n\u00039\u0015!D:ue&tw\rT5uKJ\fG.F\u0001I!\tq\u0012*\u0003\u0002K?\ti1\u000b\u001e:j]\u001ed\u0015\u000e^3sC2Da\u0001\u0014\u0001!\u0002\u0013A\u0015AD:ue&tw\rT5uKJ\fG\u000e\t")
public class PatternComprehensionTest
extends SemanticFunSuite {
    private final NodePattern n = new NodePattern((Option)new Some((Object)this.variable("n")), (Seq)Seq$.MODULE$.empty(), (Option)None$.MODULE$, NodePattern$.MODULE$.apply$default$4(), this.pos());
    private final NodePattern x = new NodePattern((Option)new Some((Object)this.variable("x")), (Seq)Seq$.MODULE$.empty(), (Option)None$.MODULE$, NodePattern$.MODULE$.apply$default$4(), this.pos());
    private final RelationshipPattern r = new RelationshipPattern((Option)None$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, RelationshipPattern$.MODULE$.apply$default$6(), RelationshipPattern$.MODULE$.apply$default$7(), this.pos());
    private final RelationshipsPattern pattern = new RelationshipsPattern(new RelationshipChain((PatternElement)this.n(), this.r(), this.x(), this.pos()), this.pos());
    private final Property property = new Property((Expression)this.variable("x"), new PropertyKeyName("prop", this.pos()), this.pos());
    private final Property failingProperty = new Property((Expression)this.variable("missing"), new PropertyKeyName("prop", this.pos()), this.pos());
    private final StringLiteral stringLiteral = new StringLiteral("APA", this.pos());

    public NodePattern n() {
        return this.n;
    }

    public NodePattern x() {
        return this.x;
    }

    public RelationshipPattern r() {
        return this.r;
    }

    public RelationshipsPattern pattern() {
        return this.pattern;
    }

    public Property property() {
        return this.property;
    }

    public Property failingProperty() {
        return this.failingProperty;
    }

    public StringLiteral stringLiteral() {
        return this.stringLiteral;
    }

    public PatternComprehensionTest() {
        this.test("pattern comprehension on a property returns the expected type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternComprehensionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternComprehension expression = new PatternComprehension((Option)None$.MODULE$, this.$outer.pattern(), (Option)None$.MODULE$, (Expression)this.$outer.property(), this.$outer.pos(), Predef$.MODULE$.Set().empty());
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)expression).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)expression).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny()).covariant()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("pattern comprehension with literal string projection has correct type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternComprehensionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternComprehension expression = new PatternComprehension((Option)None$.MODULE$, this.$outer.pattern(), (Option)None$.MODULE$, (Expression)this.$outer.stringLiteral(), this.$outer.pos(), Predef$.MODULE$.Set().empty());
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)expression).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(this.$outer.types((Expression)expression).apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()).invariant()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("inner projection using missing identifier reports error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternComprehensionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternComprehension expression = new PatternComprehension((Option)None$.MODULE$, this.$outer.pattern(), (Option)None$.MODULE$, (Expression)this.$outer.failingProperty(), this.$outer.pos(), Predef$.MODULE$.Set().empty());
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)expression).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("Variable `missing` not defined", this.$outer.pos(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("inner filter using missing identifier reports error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternComprehensionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternComprehension expression = new PatternComprehension((Option)None$.MODULE$, this.$outer.pattern(), (Option)new Some((Object)this.$outer.failingProperty()), (Expression)this.$outer.stringLiteral(), this.$outer.pos(), Predef$.MODULE$.Set().empty());
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)expression).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("Variable `missing` not defined", this.$outer.pos(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("pattern can't reuse identifier with different type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PatternComprehensionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternComprehension expression = new PatternComprehension((Option)None$.MODULE$, this.$outer.pattern(), (Option)None$.MODULE$, (Expression)this.$outer.stringLiteral(), this.$outer.pos(), Predef$.MODULE$.Set().empty());
                SemanticState semanticState = (SemanticState)SemanticState$.MODULE$.clean().declareVariable((LogicalVariable)this.$outer.variable("n"), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTBoolean()), SemanticState$.MODULE$.clean().declareVariable$default$3(), SemanticState$.MODULE$.clean().declareVariable$default$4()).right().get();
                SemanticCheckResult result = (SemanticCheckResult)SemanticExpressionCheck$.MODULE$.simple((Expression)expression).apply((Object)semanticState);
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("Type mismatch: n defined with conflicting type Boolean (expected Node)", this.$outer.pos(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[]{this.$outer.pos()}))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

