/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.v4_0.ast.prettifier;

import java.io.Serializable;
import org.neo4j.cypher.internal.v4_0.ast.ActionResource;
import org.neo4j.cypher.internal.v4_0.ast.AllGraphsScope;
import org.neo4j.cypher.internal.v4_0.ast.AllQualifier;
import org.neo4j.cypher.internal.v4_0.ast.AllResource;
import org.neo4j.cypher.internal.v4_0.ast.GraphScope;
import org.neo4j.cypher.internal.v4_0.ast.LabelAllQualifier;
import org.neo4j.cypher.internal.v4_0.ast.LabelQualifier;
import org.neo4j.cypher.internal.v4_0.ast.LabelsQualifier;
import org.neo4j.cypher.internal.v4_0.ast.NamedGraphScope;
import org.neo4j.cypher.internal.v4_0.ast.NoResource;
import org.neo4j.cypher.internal.v4_0.ast.PrivilegeQualifier;
import org.neo4j.cypher.internal.v4_0.ast.PropertiesResource;
import org.neo4j.cypher.internal.v4_0.ast.PropertyResource;
import org.neo4j.cypher.internal.v4_0.ast.RelationshipAllQualifier;
import org.neo4j.cypher.internal.v4_0.ast.RelationshipQualifier;
import org.neo4j.cypher.internal.v4_0.ast.RelationshipsQualifier;
import org.neo4j.cypher.internal.v4_0.ast.ShowAllPrivileges;
import org.neo4j.cypher.internal.v4_0.ast.ShowPrivilegeScope;
import org.neo4j.cypher.internal.v4_0.ast.ShowRolePrivileges;
import org.neo4j.cypher.internal.v4_0.ast.ShowUserPrivileges;
import org.neo4j.cypher.internal.v4_0.ast.prettifier.ExpressionStringifier;
import org.neo4j.cypher.internal.v4_0.ast.prettifier.Prettifier;
import org.neo4j.cypher.internal.v4_0.util.InputPosition$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class Prettifier$
implements scala.Serializable {
    public static Prettifier$ MODULE$;

    static {
        new Prettifier$();
    }

    public String extractScope(ShowPrivilegeScope scope) {
        String string;
        ShowPrivilegeScope showPrivilegeScope = scope;
        if (showPrivilegeScope instanceof ShowUserPrivileges) {
            ShowUserPrivileges showUserPrivileges = (ShowUserPrivileges)showPrivilegeScope;
            String name = showUserPrivileges.user();
            string = new StringBuilder(5).append("USER ").append(this.escapeName(name)).toString();
        } else if (showPrivilegeScope instanceof ShowRolePrivileges) {
            ShowRolePrivileges showRolePrivileges = (ShowRolePrivileges)showPrivilegeScope;
            String name = showRolePrivileges.role();
            string = new StringBuilder(5).append("ROLE ").append(this.escapeName(name)).toString();
        } else {
            string = showPrivilegeScope instanceof ShowAllPrivileges ? "ALL" : "<unknown>";
        }
        return string;
    }

    public Tuple2<String, String> extractScope(GraphScope dbScope, PrivilegeQualifier qualifier) {
        Tuple3<String, String, String> tuple3 = this.extractScope(new AllResource(InputPosition$.MODULE$.NONE()), dbScope, qualifier);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String r = (String)tuple3._1();
        String d = (String)tuple3._2();
        String q = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)r, (Object)d, (Object)q);
        Tuple3 tuple33 = tuple32;
        String r2 = (String)tuple33._1();
        String d2 = (String)tuple33._2();
        String q2 = (String)tuple33._3();
        return new Tuple2((Object)d2, (Object)q2);
    }

    public Tuple3<String, String, String> extractScope(ActionResource resource, GraphScope dbScope, PrivilegeQualifier qualifier) {
        String string;
        String string2;
        ActionResource actionResource = resource;
        if (actionResource instanceof PropertyResource) {
            PropertyResource propertyResource = (PropertyResource)actionResource;
            String name2 = propertyResource.property();
            string2 = this.escapeName(name2);
        } else if (actionResource instanceof PropertiesResource) {
            PropertiesResource propertiesResource = (PropertiesResource)actionResource;
            Seq<String> names = propertiesResource.properties();
            string2 = ((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)name -> MODULE$.escapeName((String)name), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        } else {
            string2 = actionResource instanceof NoResource ? "" : (actionResource instanceof AllResource ? "*" : "<unknown>");
        }
        String resourceName = string2;
        PrivilegeQualifier privilegeQualifier = qualifier;
        if (privilegeQualifier instanceof LabelQualifier) {
            LabelQualifier labelQualifier = (LabelQualifier)privilegeQualifier;
            String name3 = labelQualifier.label();
            string = new StringBuilder(5).append("NODE ").append(this.escapeName(name3)).toString();
        } else if (privilegeQualifier instanceof LabelsQualifier) {
            LabelsQualifier labelsQualifier = (LabelsQualifier)privilegeQualifier;
            Seq<String> names = labelsQualifier.labels();
            string = new StringBuilder(6).append("NODES ").append(((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)name -> MODULE$.escapeName((String)name), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString();
        } else if (privilegeQualifier instanceof LabelAllQualifier) {
            string = "NODES *";
        } else if (privilegeQualifier instanceof RelationshipQualifier) {
            RelationshipQualifier relationshipQualifier = (RelationshipQualifier)privilegeQualifier;
            String name4 = relationshipQualifier.reltype();
            string = new StringBuilder(13).append("RELATIONSHIP ").append(this.escapeName(name4)).toString();
        } else if (privilegeQualifier instanceof RelationshipsQualifier) {
            RelationshipsQualifier relationshipsQualifier = (RelationshipsQualifier)privilegeQualifier;
            Seq<String> names = relationshipsQualifier.reltypes();
            string = new StringBuilder(14).append("RELATIONSHIPS ").append(((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)name -> MODULE$.escapeName((String)name), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString();
        } else {
            string = privilegeQualifier instanceof RelationshipAllQualifier ? "RELATIONSHIPS *" : (privilegeQualifier instanceof AllQualifier ? "ELEMENTS *" : "<unknown>");
        }
        String segment = string;
        return new Tuple3((Object)resourceName, (Object)this.extractDbScope(dbScope), (Object)segment);
    }

    public String revokeOperation(String operation, String revokeType) {
        return new StringBuilder(2).append(operation).append("(").append(revokeType).append(")").toString();
    }

    public String extractDbScope(GraphScope dbScope) {
        String string;
        GraphScope graphScope = dbScope;
        if (graphScope instanceof NamedGraphScope) {
            NamedGraphScope namedGraphScope = (NamedGraphScope)graphScope;
            String name = namedGraphScope.database();
            string = this.escapeName(name);
        } else {
            string = graphScope instanceof AllGraphsScope ? "*" : "<unknown>";
        }
        return string;
    }

    public String escapeName(String name) {
        Seq c;
        return name.isEmpty() ? name : (Character.isJavaIdentifierStart(BoxesRunTime.unboxToInt((Object)(c = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(name.chars().toArray())).toSeq()).head())) && Character.getType(BoxesRunTime.unboxToInt((Object)c.head())) != 26 && (((SeqLike)c.tail()).isEmpty() || ((IterableLike)c.tail()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> Character.isJavaIdentifierPart(x$1))) ? name : new StringBuilder(2).append("`").append(name).append("`").toString());
    }

    public String escapeNames(Seq<String> names) {
        return ((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)name -> MODULE$.escapeName((String)name), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public Prettifier apply(ExpressionStringifier expr) {
        return new Prettifier(expr);
    }

    public Option<ExpressionStringifier> unapply(Prettifier x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.expr());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Prettifier$() {
        MODULE$ = this;
    }
}

