/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.prettifier;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier;
import org.neo4j.cypher.internal.ast.prettifier.PathStepStringifier;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.MultiRelationshipPathStep;
import org.neo4j.cypher.internal.expressions.NilPathStep;
import org.neo4j.cypher.internal.expressions.NodePathStep;
import org.neo4j.cypher.internal.expressions.PathStep;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.expressions.SingleRelationshipPathStep;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005i3A!\u0002\u0004\u0005'!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u0003<\u0001\u0011%AH\u0001\u000eEK\u001a\fW\u000f\u001c;QCRD7\u000b^3q'R\u0014\u0018N\\4jM&,'O\u0003\u0002\b\u0011\u0005Q\u0001O]3ui&4\u0017.\u001a:\u000b\u0005%Q\u0011aA1ti*\u00111\u0002D\u0001\tS:$XM\u001d8bY*\u0011QBD\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005=\u0001\u0012!\u00028f_RR'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!\"\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037qi\u0011AB\u0005\u0003;\u0019\u00111\u0003U1uQN#X\r]*ue&tw-\u001b4jKJ\fA!\u001a=qeB\u00111\u0004I\u0005\u0003C\u0019\u0011Q#\u0012=qe\u0016\u001c8/[8o'R\u0014\u0018N\\4jM&,'/\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0015\u0002\"a\u0007\u0001\t\u000by\u0011\u0001\u0019A\u0010\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005!\u001a\u0004CA\u00151\u001d\tQc\u0006\u0005\u0002,-5\tAF\u0003\u0002.%\u00051AH]8pizJ!a\f\f\u0002\rA\u0013X\rZ3g\u0013\t\t$G\u0001\u0004TiJLgn\u001a\u0006\u0003_YAQ\u0001N\u0002A\u0002U\n\u0001\u0002]1uQN#X\r\u001d\t\u0003mej\u0011a\u000e\u0006\u0003q)\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011!h\u000e\u0002\t!\u0006$\bn\u0015;fa\u0006!\"/\u001a7bi&|gn\u001d5jaB\u000bG\u000f[*uKB$b!\u0010#J\u001dN+\u0006C\u0001 D\u001b\u0005y$B\u0001!B\u0003\u0011a\u0017M\\4\u000b\u0003\t\u000bAA[1wC&\u0011\u0011g\u0010\u0005\u0006\u000b\u0012\u0001\rAR\u0001\u0004e\u0016d\u0007C\u0001\u001cH\u0013\tAuGA\bM_\u001eL7-\u00197WCJL\u0017M\u00197f\u0011\u0015QE\u00011\u0001L\u0003%!\u0017N]3di&|g\u000e\u0005\u00027\u0019&\u0011Qj\u000e\u0002\u0012'\u0016l\u0017M\u001c;jG\u0012K'/Z2uS>t\u0007\"B(\u0005\u0001\u0004\u0001\u0016A\u0002;p\u001d>$W\rE\u0002\u0016#\u001aK!A\u0015\f\u0003\r=\u0003H/[8o\u0011\u0015!F\u00011\u00016\u0003\u0011qW\r\u001f;\t\u000bY#\u0001\u0019A,\u0002\u0015%\u001cX*\u001e7uSJ+G\u000e\u0005\u0002\u00161&\u0011\u0011L\u0006\u0002\b\u0005>|G.Z1o\u0001")
public class DefaultPathStepStringifier
implements PathStepStringifier {
    private final ExpressionStringifier expr;

    @Override
    public String apply(PathStep pathStep) {
        Object object;
        PathStep pathStep2 = pathStep;
        if (pathStep2 instanceof SingleRelationshipPathStep) {
            SingleRelationshipPathStep singleRelationshipPathStep = (SingleRelationshipPathStep)pathStep2;
            LogicalVariable rel = singleRelationshipPathStep.rel();
            SemanticDirection direction = singleRelationshipPathStep.direction();
            Option toNode = singleRelationshipPathStep.toNode();
            PathStep next = singleRelationshipPathStep.next();
            object = this.relationshipPathStep(rel, direction, (Option<LogicalVariable>)toNode, next, false);
        } else if (pathStep2 instanceof NodePathStep) {
            NodePathStep nodePathStep = (NodePathStep)pathStep2;
            LogicalVariable node = nodePathStep.node();
            PathStep next = nodePathStep.next();
            object = "(" + this.expr.apply((Expression)node) + ")" + this.apply(next);
        } else if (pathStep2 instanceof MultiRelationshipPathStep) {
            MultiRelationshipPathStep multiRelationshipPathStep = (MultiRelationshipPathStep)pathStep2;
            LogicalVariable rel = multiRelationshipPathStep.rel();
            SemanticDirection direction = multiRelationshipPathStep.direction();
            Option toNode = multiRelationshipPathStep.toNode();
            PathStep next = multiRelationshipPathStep.next();
            object = this.relationshipPathStep(rel, direction, (Option<LogicalVariable>)toNode, next, true);
        } else if (pathStep2 instanceof NilPathStep) {
            object = "";
        } else {
            throw new MatchError((Object)pathStep2);
        }
        return object;
    }

    private String relationshipPathStep(LogicalVariable rel, SemanticDirection direction, Option<LogicalVariable> toNode, PathStep next, boolean isMultiRel) {
        SemanticDirection semanticDirection = direction;
        SemanticDirection.INCOMING$ iNCOMING$ = SemanticDirection.INCOMING$.MODULE$;
        String lArrow = !(semanticDirection != null ? !semanticDirection.equals(iNCOMING$) : iNCOMING$ != null) ? "<" : "";
        SemanticDirection semanticDirection2 = direction;
        SemanticDirection.OUTGOING$ oUTGOING$ = SemanticDirection.OUTGOING$.MODULE$;
        String rArrow = !(semanticDirection2 != null ? !semanticDirection2.equals(oUTGOING$) : oUTGOING$ != null) ? ">" : "";
        String stringifiedToNode = (String)toNode.map((Function1 & Serializable)x$1 -> $this.expr.apply((Expression)x$1)).getOrElse((Function0 & Serializable)() -> "");
        String stringifiedRel = this.expr.apply((Expression)rel);
        String multiRel = isMultiRel ? "*" : "";
        return lArrow + "-[" + stringifiedRel + multiRel + "]-" + rArrow + "(" + stringifiedToNode + ")" + this.apply(next);
    }

    public DefaultPathStepStringifier(ExpressionStringifier expr) {
        this.expr = expr;
    }
}

