/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.prettifier;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.neo4j.cypher.internal.ast.ActionResource;
import org.neo4j.cypher.internal.ast.AllDatabasesQualifier;
import org.neo4j.cypher.internal.ast.AllDatabasesScope;
import org.neo4j.cypher.internal.ast.AllGraphsScope;
import org.neo4j.cypher.internal.ast.AllLabelResource;
import org.neo4j.cypher.internal.ast.AllPropertyResource;
import org.neo4j.cypher.internal.ast.AllQualifier;
import org.neo4j.cypher.internal.ast.DatabaseName;
import org.neo4j.cypher.internal.ast.DatabaseScope;
import org.neo4j.cypher.internal.ast.DefaultDatabaseScope;
import org.neo4j.cypher.internal.ast.DefaultGraphScope;
import org.neo4j.cypher.internal.ast.ElementQualifier;
import org.neo4j.cypher.internal.ast.ElementsAllQualifier;
import org.neo4j.cypher.internal.ast.FunctionAllQualifier;
import org.neo4j.cypher.internal.ast.FunctionQualifier;
import org.neo4j.cypher.internal.ast.GraphAction;
import org.neo4j.cypher.internal.ast.GraphScope;
import org.neo4j.cypher.internal.ast.HomeDatabaseScope;
import org.neo4j.cypher.internal.ast.HomeGraphScope;
import org.neo4j.cypher.internal.ast.LabelAllQualifier;
import org.neo4j.cypher.internal.ast.LabelQualifier;
import org.neo4j.cypher.internal.ast.LabelResource;
import org.neo4j.cypher.internal.ast.LabelsResource;
import org.neo4j.cypher.internal.ast.LoadAllQualifier;
import org.neo4j.cypher.internal.ast.LoadCidrQualifier;
import org.neo4j.cypher.internal.ast.LoadUrlQualifier;
import org.neo4j.cypher.internal.ast.NamedDatabasesScope;
import org.neo4j.cypher.internal.ast.NamedGraphsScope;
import org.neo4j.cypher.internal.ast.NamespacedName;
import org.neo4j.cypher.internal.ast.ParameterName;
import org.neo4j.cypher.internal.ast.PatternQualifier;
import org.neo4j.cypher.internal.ast.PrivilegeQualifier;
import org.neo4j.cypher.internal.ast.ProcedureAllQualifier;
import org.neo4j.cypher.internal.ast.ProcedureQualifier;
import org.neo4j.cypher.internal.ast.PropertiesResource;
import org.neo4j.cypher.internal.ast.PropertyResource;
import org.neo4j.cypher.internal.ast.RelationshipAllQualifier;
import org.neo4j.cypher.internal.ast.RelationshipQualifier;
import org.neo4j.cypher.internal.ast.SettingAllQualifier;
import org.neo4j.cypher.internal.ast.SettingQualifier;
import org.neo4j.cypher.internal.ast.ShowAllPrivileges;
import org.neo4j.cypher.internal.ast.ShowPrivilegeScope;
import org.neo4j.cypher.internal.ast.ShowRolesPrivileges;
import org.neo4j.cypher.internal.ast.ShowUserPrivileges;
import org.neo4j.cypher.internal.ast.ShowUsersPrivileges;
import org.neo4j.cypher.internal.ast.SingleNamedDatabaseScope;
import org.neo4j.cypher.internal.ast.SingleNamedGraphScope;
import org.neo4j.cypher.internal.ast.Topology;
import org.neo4j.cypher.internal.ast.UserAllQualifier;
import org.neo4j.cypher.internal.ast.UserQualifier;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier$;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier$EmptyExtension$;
import org.neo4j.cypher.internal.expressions.Equals;
import org.neo4j.cypher.internal.expressions.ExplicitParameter;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.GreaterThan;
import org.neo4j.cypher.internal.expressions.GreaterThanOrEqual;
import org.neo4j.cypher.internal.expressions.In;
import org.neo4j.cypher.internal.expressions.IsNotNull;
import org.neo4j.cypher.internal.expressions.IsNull;
import org.neo4j.cypher.internal.expressions.LessThan;
import org.neo4j.cypher.internal.expressions.LessThanOrEqual;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.MapExpression;
import org.neo4j.cypher.internal.expressions.Not;
import org.neo4j.cypher.internal.expressions.NotEquals;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.StringLiteral;
import org.neo4j.cypher.internal.expressions.Variable;
import scala.DummyImplicit;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Prettifier$
implements Serializable {
    public static final Prettifier$ MODULE$ = new Prettifier$();
    private static final PartialFunction<Expression, String> escapeName = new Serializable(){
        private static final long serialVersionUID = 0L;

        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
            A1 A1 = x1;
            if (A1 instanceof StringLiteral) {
                StringLiteral stringLiteral = (StringLiteral)A1;
                String s = stringLiteral.value();
                return (B1)ExpressionStringifier$.MODULE$.backtick(s, ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3());
            }
            if (A1 instanceof Parameter) {
                Parameter parameter = (Parameter)A1;
                return (B1)("$" + ExpressionStringifier$.MODULE$.backtick(parameter.name(), ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3()));
            }
            return (B1)function1.apply(x1);
        }

        public final boolean isDefinedAt(Expression x1) {
            Expression expression = x1;
            if (expression instanceof StringLiteral) {
                return true;
            }
            return expression instanceof Parameter;
        }
    };

    public Prettifier.ClausePrettifier $lessinit$greater$default$2() {
        return Prettifier$EmptyExtension$.MODULE$;
    }

    public boolean $lessinit$greater$default$3() {
        return true;
    }

    public String prettifyRename(String commandName, Expression fromName, Expression toName, boolean ifExists) {
        String maybeIfExists = ifExists ? " IF EXISTS" : "";
        return commandName + " " + this.escapeName().apply((Object)fromName) + maybeIfExists + " TO " + this.escapeName().apply((Object)toName);
    }

    public String extractScope(ShowPrivilegeScope scope) {
        ShowPrivilegeScope showPrivilegeScope = scope;
        if (showPrivilegeScope instanceof ShowUserPrivileges) {
            ShowUserPrivileges showUserPrivileges = (ShowUserPrivileges)showPrivilegeScope;
            Option<Expression> name = showUserPrivileges.user();
            if (name.isDefined()) {
                return "USER " + this.escapeName().apply(name.get());
            }
            return "USER";
        }
        if (showPrivilegeScope instanceof ShowUsersPrivileges) {
            ShowUsersPrivileges showUsersPrivileges = (ShowUsersPrivileges)showPrivilegeScope;
            List<Expression> names = showUsersPrivileges.users();
            if (names.size() == 1) {
                return "USER " + this.escapeName().apply(names.head());
            }
            return "USERS " + this.escapeNames((Seq<Expression>)names);
        }
        if (showPrivilegeScope instanceof ShowRolesPrivileges) {
            ShowRolesPrivileges showRolesPrivileges = (ShowRolesPrivileges)showPrivilegeScope;
            List<Expression> names = showRolesPrivileges.roles();
            if (names.size() == 1) {
                return "ROLE " + this.escapeName().apply(names.head());
            }
            return "ROLES " + this.escapeNames((Seq<Expression>)names);
        }
        if (showPrivilegeScope instanceof ShowAllPrivileges) {
            return "ALL";
        }
        return "<unknown>";
    }

    public String revokeOperation(String operation, String revokeType) {
        return operation + "(" + revokeType + ")";
    }

    public String prettifyDatabasePrivilege(String privilegeName, DatabaseScope dbScope, List<PrivilegeQualifier> qualifier, String preposition, Seq<Expression> roleNames) {
        Tuple3<String, Object, Object> tuple3 = this.extractDbScope(dbScope);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String dbName = (String)tuple3._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        boolean multiple = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)dbName, (Object)BoxesRunTime.boxToBoolean((boolean)bl), (Object)BoxesRunTime.boxToBoolean((boolean)multiple));
        String dbName2 = (String)tuple32._1();
        default = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
        boolean multiple2 = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
        String db = default ? dbName2 + " DATABASE" : (multiple2 ? "DATABASES " + dbName2 : "DATABASE " + dbName2);
        return privilegeName + this.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$extractQualifierString(qualifier) + " ON " + db + " " + preposition + " " + this.escapeNames(roleNames);
    }

    /*
     * Unable to fully structure code
     */
    public String prettifyGraphPrivilege(String privilegeName, GraphScope graphScope, String qualifierString, Option<ActionResource> resource, String preposition, Seq<Expression> roleNames) {
        var9_7 = false;
        var10_8 = null;
        var11_9 = resource;
        if (!(var11_9 instanceof Some)) ** GOTO lbl-1000
        var9_7 = true;
        var10_8 = (Some)var11_9;
        var12_10 = (ActionResource)var10_8.value();
        if (var12_10 instanceof PropertyResource) {
            var13_11 = (PropertyResource)var12_10;
            name = var13_11.property();
            v0 = " {" + ExpressionStringifier$.MODULE$.backtick(name, ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3()) + "}";
        } else if (var9_7 && (var15_13 = (ActionResource)var10_8.value()) instanceof PropertiesResource) {
            var16_14 = (PropertiesResource)var15_13;
            names = var16_14.properties();
            v0 = " {" + ((IterableOnceOps)names.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$prettifyGraphPrivilege$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)())).mkString(", ") + "}";
        } else if (var9_7 && (var18_16 = (ActionResource)var10_8.value()) instanceof AllPropertyResource) {
            v0 = " {*}";
        } else if (var9_7 && (var19_17 = (ActionResource)var10_8.value()) instanceof LabelResource) {
            var20_18 = (LabelResource)var19_17;
            name = var20_18.label();
            v0 = " " + ExpressionStringifier$.MODULE$.backtick(name, ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3());
        } else if (var9_7 && (var22_20 = (ActionResource)var10_8.value()) instanceof LabelsResource) {
            var23_21 = (LabelsResource)var22_20;
            names = var23_21.labels();
            v0 = " " + ((IterableOnceOps)names.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$prettifyGraphPrivilege$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)())).mkString(", ");
        } else if (var9_7 && (var25_23 = (ActionResource)var10_8.value()) instanceof AllLabelResource) {
            v0 = " *";
        } else if (None$.MODULE$.equals(var11_9)) {
            v0 = "";
        } else {
            throw new IllegalStateException("Unknown resource: " + resource);
        }
        resourceName = v0;
        scope = String.valueOf(this.extractGraphScope(graphScope));
        return privilegeName + resourceName + " ON " + scope + qualifierString + " " + preposition + " " + this.escapeNames(roleNames);
    }

    public PartialFunction<List<PrivilegeQualifier>, String> prettifyLoadPrivilegeQualifier(ExpressionStringifier expr) {
        return new Serializable(expr){
            private static final long serialVersionUID = 0L;
            private final ExpressionStringifier expr$1;

            public final <A1 extends List<PrivilegeQualifier>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                .colon.colon colon2 = null;
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    bl = true;
                    colon2 = (.colon.colon)A1;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadAllQualifier && Nil$.MODULE$.equals(list)) {
                        return (B1)"ALL DATA";
                    }
                }
                if (bl) {
                    LoadUrlQualifier loadUrlQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadUrlQualifier && (either = (loadUrlQualifier = (LoadUrlQualifier)privilegeQualifier).url()) instanceof Left) {
                        Left left = (Left)either;
                        String urlString = (String)left.value();
                        if (Nil$.MODULE$.equals(list)) {
                            return (B1)("URL " + this.expr$1.quote(urlString));
                        }
                    }
                }
                if (bl) {
                    LoadUrlQualifier loadUrlQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadUrlQualifier && (either = (loadUrlQualifier = (LoadUrlQualifier)privilegeQualifier).url()) instanceof Right) {
                        Right right = (Right)either;
                        Parameter urlParam = (Parameter)right.value();
                        if (Nil$.MODULE$.equals(list)) {
                            return (B1)("URL " + this.expr$1.apply((Expression)urlParam));
                        }
                    }
                }
                if (bl) {
                    LoadCidrQualifier loadCidrQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadCidrQualifier && (either = (loadCidrQualifier = (LoadCidrQualifier)privilegeQualifier).cidr()) instanceof Left) {
                        Left left = (Left)either;
                        String cidrString = (String)left.value();
                        if (Nil$.MODULE$.equals(list)) {
                            return (B1)("CIDR " + this.expr$1.quote(cidrString));
                        }
                    }
                }
                if (bl) {
                    LoadCidrQualifier loadCidrQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadCidrQualifier && (either = (loadCidrQualifier = (LoadCidrQualifier)privilegeQualifier).cidr()) instanceof Right) {
                        Right right = (Right)either;
                        Parameter cidrParam = (Parameter)right.value();
                        if (Nil$.MODULE$.equals(list)) {
                            return (B1)("CIDR " + this.expr$1.apply((Expression)cidrParam));
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(List<PrivilegeQualifier> x1) {
                boolean bl = false;
                .colon.colon colon2 = null;
                List<PrivilegeQualifier> list = x1;
                if (list instanceof .colon.colon) {
                    bl = true;
                    colon2 = (.colon.colon)list;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list2 = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadAllQualifier && Nil$.MODULE$.equals(list2)) {
                        return true;
                    }
                }
                if (bl) {
                    LoadUrlQualifier loadUrlQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list3 = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadUrlQualifier && (either = (loadUrlQualifier = (LoadUrlQualifier)privilegeQualifier).url()) instanceof Left && Nil$.MODULE$.equals(list3)) {
                        return true;
                    }
                }
                if (bl) {
                    LoadUrlQualifier loadUrlQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list4 = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadUrlQualifier && (either = (loadUrlQualifier = (LoadUrlQualifier)privilegeQualifier).url()) instanceof Right && Nil$.MODULE$.equals(list4)) {
                        return true;
                    }
                }
                if (bl) {
                    LoadCidrQualifier loadCidrQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list5 = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadCidrQualifier && (either = (loadCidrQualifier = (LoadCidrQualifier)privilegeQualifier).cidr()) instanceof Left && Nil$.MODULE$.equals(list5)) {
                        return true;
                    }
                }
                if (bl) {
                    LoadCidrQualifier loadCidrQualifier;
                    Either<String, Parameter> either;
                    PrivilegeQualifier privilegeQualifier = (PrivilegeQualifier)colon2.head();
                    List list6 = colon2.next$access$1();
                    if (privilegeQualifier instanceof LoadCidrQualifier && (either = (loadCidrQualifier = (LoadCidrQualifier)privilegeQualifier).cidr()) instanceof Right && Nil$.MODULE$.equals(list6)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.expr$1 = expr$1;
            }
        };
    }

    public String prettifyGraphQualifier(GraphAction action, List<PrivilegeQualifier> qualifier) {
        if (action.name().equals("WRITE") || action.name().equals("SET LABEL") || action.name().equals("REMOVE LABEL")) {
            return "";
        }
        return this.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$extractQualifierString(qualifier);
    }

    private Option<String> extractQualifierPart(List<PrivilegeQualifier> qualifier) {
        PrivilegeQualifier privilegeQualifier;
        PrivilegeQualifier privilegeQualifier2;
        PrivilegeQualifier privilegeQualifier3;
        PrivilegeQualifier privilegeQualifier4;
        PrivilegeQualifier privilegeQualifier5;
        PrivilegeQualifier privilegeQualifier6;
        PrivilegeQualifier privilegeQualifier7;
        boolean bl = false;
        .colon.colon colon2 = null;
        List<PrivilegeQualifier> list = qualifier;
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            PrivilegeQualifier privilegeQualifier8 = (PrivilegeQualifier)colon2.head();
            List list2 = colon2.next$access$1();
            if (privilegeQualifier8 instanceof LabelQualifier && Nil$.MODULE$.equals(list2)) {
                return new Some((Object)("NODE " + colon2.map((Function1)Prettifier$.stringify$1()).mkString(", ")));
            }
        }
        if (bl && (privilegeQualifier7 = (PrivilegeQualifier)colon2.head()) instanceof LabelQualifier) {
            return new Some((Object)("NODES " + colon2.map((Function1)Prettifier$.stringify$1()).mkString(", ")));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier9 = (PrivilegeQualifier)colon2.head();
            List list3 = colon2.next$access$1();
            if (privilegeQualifier9 instanceof LabelAllQualifier && Nil$.MODULE$.equals(list3)) {
                return new Some((Object)"NODES *");
            }
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier10 = (PrivilegeQualifier)colon2.head();
            List list4 = colon2.next$access$1();
            if (privilegeQualifier10 instanceof RelationshipQualifier && Nil$.MODULE$.equals(list4)) {
                return new Some((Object)("RELATIONSHIP " + colon2.map((Function1)Prettifier$.stringify$1()).mkString(", ")));
            }
        }
        if (bl && (privilegeQualifier6 = (PrivilegeQualifier)colon2.head()) instanceof RelationshipQualifier) {
            return new Some((Object)("RELATIONSHIPS " + colon2.map((Function1)Prettifier$.stringify$1()).mkString(", ")));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier11 = (PrivilegeQualifier)colon2.head();
            List list5 = colon2.next$access$1();
            if (privilegeQualifier11 instanceof RelationshipAllQualifier && Nil$.MODULE$.equals(list5)) {
                return new Some((Object)"RELATIONSHIPS *");
            }
        }
        if (bl && (privilegeQualifier5 = (PrivilegeQualifier)colon2.head()) instanceof ElementQualifier) {
            return new Some((Object)("ELEMENTS " + colon2.map((Function1)Prettifier$.stringify$1()).mkString(", ")));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier12 = (PrivilegeQualifier)colon2.head();
            List list6 = colon2.next$access$1();
            if (privilegeQualifier12 instanceof ElementsAllQualifier && Nil$.MODULE$.equals(list6)) {
                return new Some((Object)"ELEMENTS *");
            }
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier13 = (PrivilegeQualifier)colon2.head();
            List list7 = colon2.next$access$1();
            if (privilegeQualifier13 instanceof PatternQualifier) {
                PatternQualifier patternQualifier = (PatternQualifier)privilegeQualifier13;
                Seq<PrivilegeQualifier> lqs = patternQualifier.labelQualifiers();
                Option<Variable> v = patternQualifier.variable();
                Expression e = patternQualifier.expression();
                if (Nil$.MODULE$.equals(list7)) {
                    return new Some((Object)("FOR " + Prettifier$.extractPropertyRuleExpression$1(lqs, v, e)));
                }
            }
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier14 = (PrivilegeQualifier)colon2.head();
            List list8 = colon2.next$access$1();
            if (privilegeQualifier14 instanceof UserQualifier) {
                UserQualifier userQualifier = (UserQualifier)privilegeQualifier14;
                Expression user = userQualifier.username();
                if (Nil$.MODULE$.equals(list8)) {
                    return new Some((Object)("(" + this.escapeName().apply((Object)user) + ")"));
                }
            }
        }
        if (bl && (privilegeQualifier4 = (PrivilegeQualifier)colon2.head()) instanceof UserQualifier) {
            return new Some((Object)("(" + colon2.map((Function1)Prettifier$.stringify$1()).mkString(", ") + ")"));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier15 = (PrivilegeQualifier)colon2.head();
            List list9 = colon2.next$access$1();
            if (privilegeQualifier15 instanceof UserAllQualifier && Nil$.MODULE$.equals(list9)) {
                return new Some((Object)"(*)");
            }
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier16 = (PrivilegeQualifier)colon2.head();
            List list10 = colon2.next$access$1();
            if (privilegeQualifier16 instanceof AllQualifier && Nil$.MODULE$.equals(list10)) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier17 = (PrivilegeQualifier)colon2.head();
            List list11 = colon2.next$access$1();
            if (privilegeQualifier17 instanceof AllDatabasesQualifier && Nil$.MODULE$.equals(list11)) {
                return None$.MODULE$;
            }
        }
        if (bl && (privilegeQualifier3 = (PrivilegeQualifier)colon2.head()) instanceof ProcedureQualifier) {
            return new Some((Object)colon2.map((Function1)Prettifier$.stringify$1()).mkString(", "));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier18 = (PrivilegeQualifier)colon2.head();
            List list12 = colon2.next$access$1();
            if (privilegeQualifier18 instanceof ProcedureAllQualifier && Nil$.MODULE$.equals(list12)) {
                return new Some((Object)"*");
            }
        }
        if (bl && (privilegeQualifier2 = (PrivilegeQualifier)colon2.head()) instanceof FunctionQualifier) {
            return new Some((Object)colon2.map((Function1)Prettifier$.stringify$1()).mkString(", "));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier19 = (PrivilegeQualifier)colon2.head();
            List list13 = colon2.next$access$1();
            if (privilegeQualifier19 instanceof FunctionAllQualifier && Nil$.MODULE$.equals(list13)) {
                return new Some((Object)"*");
            }
        }
        if (bl && (privilegeQualifier = (PrivilegeQualifier)colon2.head()) instanceof SettingQualifier) {
            return new Some((Object)colon2.map((Function1)Prettifier$.stringify$1()).mkString(", "));
        }
        if (bl) {
            PrivilegeQualifier privilegeQualifier20 = (PrivilegeQualifier)colon2.head();
            List list14 = colon2.next$access$1();
            if (privilegeQualifier20 instanceof SettingAllQualifier && Nil$.MODULE$.equals(list14)) {
                return new Some((Object)"*");
            }
        }
        return new Some((Object)"<unknown>");
    }

    public String org$neo4j$cypher$internal$ast$prettifier$Prettifier$$extractQualifierString(List<PrivilegeQualifier> qualifier) {
        Option<String> qualifierPart = this.extractQualifierPart(qualifier);
        Option<String> option = qualifierPart;
        if (option instanceof Some) {
            Some some = (Some)option;
            String string = (String)some.value();
            return " " + string;
        }
        return "";
    }

    public Tuple3<String, Object, Object> extractDbScope(DatabaseScope dbScope) {
        boolean bl = false;
        NamedDatabasesScope namedDatabasesScope = null;
        DatabaseScope databaseScope = dbScope;
        if (databaseScope instanceof SingleNamedDatabaseScope) {
            SingleNamedDatabaseScope singleNamedDatabaseScope = (SingleNamedDatabaseScope)databaseScope;
            DatabaseName name = singleNamedDatabaseScope.database();
            return new Tuple3((Object)this.escapeName(name, DummyImplicit$.MODULE$.dummyImplicit()), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (databaseScope instanceof AllDatabasesScope) {
            return new Tuple3((Object)"*", (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (databaseScope instanceof DefaultDatabaseScope) {
            return new Tuple3((Object)"DEFAULT", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (databaseScope instanceof HomeDatabaseScope) {
            return new Tuple3((Object)"HOME", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (databaseScope instanceof NamedDatabasesScope) {
            SeqOps seqOps;
            bl = true;
            namedDatabasesScope = (NamedDatabasesScope)databaseScope;
            Seq<DatabaseName> seq = namedDatabasesScope.databases();
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                DatabaseName databaseName = (DatabaseName)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                return new Tuple3((Object)this.escapeName(databaseName, DummyImplicit$.MODULE$.dummyImplicit()), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        if (bl) {
            Seq<DatabaseName> databaseNames = namedDatabasesScope.databases();
            return new Tuple3((Object)this.escapeNames(databaseNames, DummyImplicit$.MODULE$.dummyImplicit()), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        throw new MatchError((Object)databaseScope);
    }

    public String extractGraphScope(GraphScope graphScope) {
        boolean bl = false;
        NamedGraphsScope namedGraphsScope = null;
        GraphScope graphScope2 = graphScope;
        if (graphScope2 instanceof SingleNamedGraphScope) {
            SingleNamedGraphScope singleNamedGraphScope = (SingleNamedGraphScope)graphScope2;
            DatabaseName name = singleNamedGraphScope.graph();
            return "GRAPH " + this.escapeName(name, DummyImplicit$.MODULE$.dummyImplicit());
        }
        if (graphScope2 instanceof AllGraphsScope) {
            return "GRAPH *";
        }
        if (graphScope2 instanceof DefaultGraphScope) {
            return "DEFAULT GRAPH";
        }
        if (graphScope2 instanceof HomeGraphScope) {
            return "HOME GRAPH";
        }
        if (graphScope2 instanceof NamedGraphsScope) {
            SeqOps seqOps;
            bl = true;
            namedGraphsScope = (NamedGraphsScope)graphScope2;
            Seq<DatabaseName> seq = namedGraphsScope.graphs();
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                DatabaseName graph = (DatabaseName)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                return "GRAPH " + this.escapeName(graph, DummyImplicit$.MODULE$.dummyImplicit());
            }
        }
        if (bl) {
            Seq<DatabaseName> graphs = namedGraphsScope.graphs();
            return "GRAPHS " + this.escapeNames(graphs, DummyImplicit$.MODULE$.dummyImplicit());
        }
        throw new MatchError((Object)graphScope2);
    }

    public String escapeName(Either<String, Parameter> name) {
        Either<String, Parameter> either = name;
        if (either instanceof Left) {
            Left left = (Left)either;
            String s = (String)left.value();
            return ExpressionStringifier$.MODULE$.backtick(s, ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3());
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Parameter p = (Parameter)right.value();
            return "$" + ExpressionStringifier$.MODULE$.backtick(p.name(), ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3());
        }
        throw new MatchError(either);
    }

    public String escapeName(DatabaseName name, DummyImplicit d) {
        boolean bl = false;
        NamespacedName namespacedName = null;
        DatabaseName databaseName = name;
        if (databaseName instanceof NamespacedName) {
            bl = true;
            namespacedName = (NamespacedName)databaseName;
            List<String> names = namespacedName.nameComponents();
            Option<String> option = namespacedName.namespace();
            if (option instanceof Some) {
                Some some = (Some)option;
                String namespace = (String)some.value();
                return ExpressionStringifier$.MODULE$.backtick(namespace, ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3()) + "." + ExpressionStringifier$.MODULE$.backtick(names.mkString("."), ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3());
            }
        }
        if (bl) {
            List<String> names = namespacedName.nameComponents();
            Option<String> option = namespacedName.namespace();
            if (None$.MODULE$.equals(option)) {
                return ExpressionStringifier$.MODULE$.backtick(names.mkString("."), ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3());
            }
        }
        if (databaseName instanceof ParameterName) {
            ParameterName parameterName = (ParameterName)databaseName;
            Parameter p = parameterName.parameter();
            return "$" + ExpressionStringifier$.MODULE$.backtick(p.name(), ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3());
        }
        throw new MatchError((Object)databaseName);
    }

    public PartialFunction<Expression, String> escapeName() {
        return escapeName;
    }

    public String escapeNames(Seq<Expression> names) {
        return ((IterableOnceOps)names.map(this.escapeName())).mkString(", ");
    }

    public String escapeNames(Seq<DatabaseName> names, DummyImplicit d) {
        return ((IterableOnceOps)names.map((Function1 & Serializable)databaseName -> MODULE$.escapeName((DatabaseName)databaseName, d))).mkString(", ");
    }

    public String extractTopology(Topology topology) {
        String primariesString = (String)topology.primaries().flatMap((Function1 & Serializable)x0$1 -> Prettifier$.$anonfun$extractTopology$1(BoxesRunTime.unboxToInt((Object)x0$1))).getOrElse((Function0 & Serializable)() -> "");
        String maybeSecondariesString = (String)topology.secondaries().flatMap((Function1 & Serializable)x0$2 -> Prettifier$.$anonfun$extractTopology$3(BoxesRunTime.unboxToInt((Object)x0$2))).getOrElse((Function0 & Serializable)() -> "");
        return " TOPOLOGY" + primariesString + maybeSecondariesString;
    }

    public Prettifier apply(ExpressionStringifier expr, Prettifier.ClausePrettifier extension, boolean useInCommands) {
        return new Prettifier(expr, extension, useInCommands);
    }

    public Prettifier.ClausePrettifier apply$default$2() {
        return Prettifier$EmptyExtension$.MODULE$;
    }

    public boolean apply$default$3() {
        return true;
    }

    public Option<Tuple3<ExpressionStringifier, Prettifier.ClausePrettifier, Object>> unapply(Prettifier x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.expr(), (Object)x$0.extension(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.useInCommands())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Prettifier$.class);
    }

    public static final /* synthetic */ String $anonfun$prettifyGraphPrivilege$1(String x$33) {
        return ExpressionStringifier$.MODULE$.backtick(x$33, ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3());
    }

    public static final /* synthetic */ String $anonfun$prettifyGraphPrivilege$2(String x$34) {
        return ExpressionStringifier$.MODULE$.backtick(x$34, ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3());
    }

    public static final String org$neo4j$cypher$internal$ast$prettifier$Prettifier$$stringifyQualifiedName$1(String glob) {
        if (glob.contains("..")) {
            String x$1 = glob;
            boolean x$2 = true;
            boolean x$3 = ExpressionStringifier$.MODULE$.backtick$default$2();
            return ExpressionStringifier$.MODULE$.backtick(x$1, x$3, true);
        }
        String escapedGlob = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(glob), '.')), (Function1 & Serializable)x$35 -> {
            String x$4 = x$35;
            boolean x$5 = true;
            boolean x$6 = ExpressionStringifier$.MODULE$.backtick$default$2();
            return ExpressionStringifier$.MODULE$.backtick(x$4, x$6, true);
        }, ClassTag$.MODULE$.apply(String.class))).mkString(".");
        if (((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(glob)))).equals(BoxesRunTime.boxToCharacter((char)'.'))) {
            return escapedGlob + ".";
        }
        return escapedGlob;
    }

    private static final PartialFunction stringify$1() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends PrivilegeQualifier, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LabelQualifier) {
                    LabelQualifier labelQualifier = (LabelQualifier)A1;
                    String name = labelQualifier.label();
                    return (B1)ExpressionStringifier$.MODULE$.backtick(name, ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3());
                }
                if (A1 instanceof RelationshipQualifier) {
                    RelationshipQualifier relationshipQualifier = (RelationshipQualifier)A1;
                    String name = relationshipQualifier.reltype();
                    return (B1)ExpressionStringifier$.MODULE$.backtick(name, ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3());
                }
                if (A1 instanceof ElementQualifier) {
                    ElementQualifier elementQualifier = (ElementQualifier)A1;
                    String name = elementQualifier.value();
                    return (B1)ExpressionStringifier$.MODULE$.backtick(name, ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3());
                }
                if (A1 instanceof UserQualifier) {
                    UserQualifier userQualifier = (UserQualifier)A1;
                    Expression name = userQualifier.username();
                    return (B1)Prettifier$.MODULE$.escapeName().apply((Object)name);
                }
                if (A1 instanceof ProcedureQualifier) {
                    ProcedureQualifier procedureQualifier = (ProcedureQualifier)A1;
                    String glob = procedureQualifier.glob();
                    return (B1)Prettifier$.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$stringifyQualifiedName$1(glob);
                }
                if (A1 instanceof FunctionQualifier) {
                    FunctionQualifier functionQualifier = (FunctionQualifier)A1;
                    String glob = functionQualifier.glob();
                    return (B1)Prettifier$.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$stringifyQualifiedName$1(glob);
                }
                if (A1 instanceof SettingQualifier) {
                    SettingQualifier settingQualifier = (SettingQualifier)A1;
                    String glob = settingQualifier.glob();
                    return (B1)Prettifier$.org$neo4j$cypher$internal$ast$prettifier$Prettifier$$stringifyQualifiedName$1(glob);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(PrivilegeQualifier x1) {
                PrivilegeQualifier privilegeQualifier = x1;
                if (privilegeQualifier instanceof LabelQualifier) {
                    return true;
                }
                if (privilegeQualifier instanceof RelationshipQualifier) {
                    return true;
                }
                if (privilegeQualifier instanceof ElementQualifier) {
                    return true;
                }
                if (privilegeQualifier instanceof UserQualifier) {
                    return true;
                }
                if (privilegeQualifier instanceof ProcedureQualifier) {
                    return true;
                }
                if (privilegeQualifier instanceof FunctionQualifier) {
                    return true;
                }
                return privilegeQualifier instanceof SettingQualifier;
            }
        };
    }

    private static final String propertyAndWherePrettifier$1(Expression e2, Option variableNameString$1, String labels$1) {
        return "(" + variableNameString$1.getOrElse((Function0 & Serializable)() -> "") + labels$1 + ") WHERE " + ExpressionStringifier$.MODULE$.apply((Function1<Expression, String>)(Function1 & Serializable)e -> e.asCanonicalStringVal(), ExpressionStringifier$.MODULE$.apply$default$2(), ExpressionStringifier$.MODULE$.apply$default$3(), ExpressionStringifier$.MODULE$.apply$default$4(), ExpressionStringifier$.MODULE$.apply$default$5()).apply(e2);
    }

    private static final String propertyInNodePrettifier$1(PropertyKeyName propertyKeyName, Expression value2, Option variableNameString$1, String labels$1) {
        return "(" + variableNameString$1.getOrElse((Function0 & Serializable)() -> "n") + labels$1 + ") WHERE " + variableNameString$1.getOrElse((Function0 & Serializable)() -> "n") + "." + ExpressionStringifier$.MODULE$.backtick(propertyKeyName.name(), ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3()) + " = " + ExpressionStringifier$.MODULE$.apply((Function1<Expression, String>)(Function1 & Serializable)value -> value.asCanonicalStringVal(), ExpressionStringifier$.MODULE$.apply$default$2(), ExpressionStringifier$.MODULE$.apply$default$3(), ExpressionStringifier$.MODULE$.apply$default$4(), ExpressionStringifier$.MODULE$.apply$default$5()).apply(value2);
    }

    private static final String extractPropertyRuleExpression$1(Seq labelQualifiers, Option variable, Expression expression) {
        Tuple2 tuple2;
        SeqOps seqOps;
        MapExpression mapExpression;
        Seq seq;
        String labels2 = (String)new Some((Object)((IterableOnceOps)labelQualifiers.flatMap((Function1 & Serializable)x0$1 -> {
            PrivilegeQualifier privilegeQualifier = x0$1;
            if (privilegeQualifier instanceof LabelQualifier) {
                LabelQualifier labelQualifier = (LabelQualifier)privilegeQualifier;
                return new Some((Object)ExpressionStringifier$.MODULE$.backtick(labelQualifier.label(), ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3()));
            }
            return None$.MODULE$;
        })).mkString("|")).filterNot((Function1 & Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)x$36.equals(""))).map((Function1 & Serializable)labels -> ":" + labels).getOrElse((Function0 & Serializable)() -> "");
        Option variableNameString = variable.map((Function1 & Serializable)v -> ExpressionStringifier$.MODULE$.backtick(v.name(), ExpressionStringifier$.MODULE$.backtick$default$2(), ExpressionStringifier$.MODULE$.backtick$default$3()));
        boolean bl = false;
        In in = null;
        Expression expression2 = expression;
        if (expression2 instanceof MapExpression && (seq = (mapExpression = (MapExpression)expression2).items()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
            PropertyKeyName propertyKeyName = (PropertyKeyName)tuple2._1();
            Expression value = (Expression)tuple2._2();
            return Prettifier$.propertyInNodePrettifier$1(propertyKeyName, value, variableNameString, labels2);
        }
        if (expression2 instanceof Equals) {
            Equals equals = (Equals)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)equals, variableNameString, labels2);
        }
        if (expression2 instanceof NotEquals) {
            NotEquals notEquals = (NotEquals)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)notEquals, variableNameString, labels2);
        }
        if (expression2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)greaterThan, variableNameString, labels2);
        }
        if (expression2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)greaterThanOrEqual, variableNameString, labels2);
        }
        if (expression2 instanceof LessThan) {
            LessThan lessThan = (LessThan)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)lessThan, variableNameString, labels2);
        }
        if (expression2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)lessThanOrEqual, variableNameString, labels2);
        }
        if (expression2 instanceof IsNull) {
            IsNull isNull = (IsNull)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)isNull, variableNameString, labels2);
        }
        if (expression2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)expression2;
            return Prettifier$.propertyAndWherePrettifier$1((Expression)isNotNull, variableNameString, labels2);
        }
        if (expression2 instanceof In) {
            bl = true;
            in = (In)expression2;
            if (in.rhs() instanceof ListLiteral) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)in, variableNameString, labels2);
            }
        }
        if (bl && in.rhs() instanceof ExplicitParameter) {
            return Prettifier$.propertyAndWherePrettifier$1((Expression)in, variableNameString, labels2);
        }
        if (expression2 instanceof Not) {
            Not not = (Not)expression2;
            Expression innerExpression = not.rhs();
            boolean bl2 = false;
            In in2 = null;
            Expression expression3 = innerExpression;
            if (expression3 instanceof Equals) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, variableNameString, labels2);
            }
            if (expression3 instanceof NotEquals) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, variableNameString, labels2);
            }
            if (expression3 instanceof GreaterThan) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, variableNameString, labels2);
            }
            if (expression3 instanceof GreaterThanOrEqual) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, variableNameString, labels2);
            }
            if (expression3 instanceof LessThan) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, variableNameString, labels2);
            }
            if (expression3 instanceof LessThanOrEqual) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, variableNameString, labels2);
            }
            if (expression3 instanceof IsNull) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, variableNameString, labels2);
            }
            if (expression3 instanceof IsNotNull) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, variableNameString, labels2);
            }
            if (expression3 instanceof In) {
                bl2 = true;
                in2 = (In)expression3;
                if (in2.rhs() instanceof ListLiteral) {
                    return Prettifier$.propertyAndWherePrettifier$1((Expression)not, variableNameString, labels2);
                }
            }
            if (bl2 && in2.rhs() instanceof ExplicitParameter) {
                return Prettifier$.propertyAndWherePrettifier$1((Expression)not, variableNameString, labels2);
            }
            throw new IllegalStateException("Unknown expression: " + ExpressionStringifier$.MODULE$.apply((Function1<Expression, String>)(Function1 & Serializable)e -> e.asCanonicalStringVal(), ExpressionStringifier$.MODULE$.apply$default$2(), ExpressionStringifier$.MODULE$.apply$default$3(), ExpressionStringifier$.MODULE$.apply$default$4(), ExpressionStringifier$.MODULE$.apply$default$5()).apply((Expression)not));
        }
        throw new IllegalStateException("Unknown expression: " + ExpressionStringifier$.MODULE$.apply((Function1<Expression, String>)(Function1 & Serializable)e -> e.asCanonicalStringVal(), ExpressionStringifier$.MODULE$.apply$default$2(), ExpressionStringifier$.MODULE$.apply$default$3(), ExpressionStringifier$.MODULE$.apply$default$4(), ExpressionStringifier$.MODULE$.apply$default$5()).apply(expression2));
    }

    public static final /* synthetic */ Some $anonfun$extractTopology$1(int x0$1) {
        int n = x0$1;
        switch (n) {
            case 1: {
                return new Some((Object)" 1 PRIMARY");
            }
        }
        return new Some((Object)(" " + n + " PRIMARIES"));
    }

    public static final /* synthetic */ Some $anonfun$extractTopology$3(int x0$2) {
        int n = x0$2;
        switch (n) {
            case 1: {
                return new Some((Object)" 1 SECONDARY");
            }
        }
        return new Some((Object)(" " + n + " SECONDARIES"));
    }

    private Prettifier$() {
    }
}

