/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.neo4j.backup.BackupService;
import org.neo4j.backup.BackupTool;
import org.neo4j.backup.ConsistencyCheck;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.MandatoryNamedArg;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalBooleanArg;
import org.neo4j.commandline.arguments.OptionalNamedArg;
import org.neo4j.commandline.arguments.common.OptionalCanonicalPath;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.server.configuration.ConfigLoader;

public class OnlineBackupCommand
implements AdminCommand {
    public static final Arguments arguments = new Arguments().withArgument((NamedArgument)new OptionalNamedArg("from", "address", "localhost:6362", "Host and port of Neo4j.")).withArgument((NamedArgument)new MandatoryNamedArg("to", "backup-path", "Directory where the backup will be made; if there is already a backup present an incremental backup will be attempted.")).withArgument((NamedArgument)new OptionalBooleanArg("check-consistency", true, "If a consistency check should be made.")).withArgument((NamedArgument)new OptionalCanonicalPath("cc-report-dir", "directory", ".", "Directory where consistency report will be written.")).withAdditionalConfig().withArgument((NamedArgument)new OptionalNamedArg("timeout", "timeout", "20m", "Timeout in the form <time>[ms|s|m|h], where the default unit is seconds."));
    private final BackupTool backupTool;
    private final Path homeDir;
    private final Path configDir;
    private ConsistencyCheckService consistencyCheckService;

    public OnlineBackupCommand(BackupTool backupTool, Path homeDir, Path configDir, ConsistencyCheckService consistencyCheckService) {
        this.backupTool = backupTool;
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.consistencyCheckService = consistencyCheckService;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        Optional additionalConfig;
        long timeout;
        File destination;
        HostnamePort address;
        ConsistencyCheck consistencyCheck = ConsistencyCheck.NONE;
        try {
            address = (HostnamePort)Converters.toHostnamePort((HostnamePort)new HostnamePort("localhost", 6362)).apply(arguments.parse("from", args));
            destination = arguments.parseMandatoryPath("to", args).toFile();
            timeout = this.parseTimeout(args);
            additionalConfig = arguments.parseOptionalPath("additional-config", args);
            if (arguments.parseBoolean("check-consistency", args)) {
                Path reportDir = (Path)arguments.parseOptionalPath("cc-report-dir", args).orElseThrow(() -> new IllegalArgumentException("cc-report-dir must be a path"));
                consistencyCheck = ConsistencyCheck.full(reportDir.toFile(), this.consistencyCheckService);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        try {
            this.backupTool.executeBackup(address, destination, consistencyCheck, this.loadConfig(additionalConfig), timeout, false);
        }
        catch (BackupTool.ToolFailureException e) {
            throw new CommandFailed("backup failed: " + e.getMessage(), (Exception)e);
        }
    }

    private long parseTimeout(String[] args) {
        return Args.parse((String[])args).getDuration("timeout", TimeUnit.MINUTES.toMillis(20L));
    }

    private Config loadConfig(Optional<Path> additionalConfig) throws CommandFailed {
        return this.withAdditionalConfig(additionalConfig, new ConfigLoader(Arrays.asList(GraphDatabaseSettings.class, ConsistencyCheckSettings.class)).loadOfflineConfig(Optional.of(this.homeDir.toFile()), Optional.of(this.configDir.resolve("neo4j.conf").toFile())));
    }

    private Config withAdditionalConfig(Optional<Path> additionalConfig, Config config) throws CommandFailed {
        if (additionalConfig.isPresent()) {
            try {
                return config.with(MapUtil.load((File)additionalConfig.get().toFile()), new Class[0]);
            }
            catch (IOException e) {
                throw new CommandFailed("Could not read additional config from " + additionalConfig.get(), (Exception)e);
            }
        }
        return config;
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("backup", new String[0]);
        }

        public Arguments allArguments() {
            return arguments;
        }

        public String description() {
            return "Perform a backup, over the network, from a running Neo4j server into a local copy of the database store (the backup). Neo4j Server must be configured to run a backup service. See http://neo4j.com/docs/operations-manual/current/backup/ for more details.\n\nWARNING: this command is experimental and subject to change.";
        }

        public String summary() {
            return "Perform a backup, over the network, from a running Neo4j server.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new OnlineBackupCommand(new BackupTool(new BackupService(outsideWorld.errorStream()), outsideWorld.errorStream()), homeDir, configDir, new ConsistencyCheckService());
        }
    }
}

