/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.restore;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.MandatoryNamedArg;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalBooleanArg;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.restore.RestoreDatabaseCommand;
import org.neo4j.server.configuration.ConfigLoader;

public class RestoreDatabaseCli
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withArgument((NamedArgument)new MandatoryNamedArg("from", "backup-directory", "Path to backup to restore from.")).withDatabase().withArgument((NamedArgument)new OptionalBooleanArg("force", false, "If an existing database should be replaced."));
    private final Path homeDir;
    private final Path configDir;

    public RestoreDatabaseCli(Path homeDir, Path configDir) {
        this.homeDir = homeDir;
        this.configDir = configDir;
    }

    private static Config loadNeo4jConfig(Path homeDir, Path configDir, String databaseName) {
        ConfigLoader configLoader = new ConfigLoader(RestoreDatabaseCli.settings());
        Config config = configLoader.loadOfflineConfig(Optional.of(homeDir.toFile()), Optional.of(configDir.resolve("neo4j.conf").toFile()));
        return config.with(MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.active_database.name(), databaseName}), new Class[0]);
    }

    private static List<Class<?>> settings() {
        ArrayList settings = new ArrayList();
        settings.add(GraphDatabaseSettings.class);
        settings.add(DatabaseManagementSystemSettings.class);
        return settings;
    }

    public void execute(String[] incomingArguments) throws IncorrectUsage, CommandFailed {
        boolean forceOverwrite;
        String fromPath;
        String databaseName;
        try {
            databaseName = arguments.parse("database", incomingArguments);
            fromPath = arguments.parse("from", incomingArguments);
            forceOverwrite = arguments.parseBoolean("force", incomingArguments);
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        Config config = RestoreDatabaseCli.loadNeo4jConfig(this.homeDir, this.configDir, databaseName);
        RestoreDatabaseCommand restoreDatabaseCommand = new RestoreDatabaseCommand((FileSystemAbstraction)new DefaultFileSystemAbstraction(), new File(fromPath), config, databaseName, forceOverwrite);
        try {
            restoreDatabaseCommand.execute();
        }
        catch (IOException e) {
            throw new CommandFailed("Failed to restore database", (Exception)e);
        }
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("restore", new String[0]);
        }

        public Arguments allArguments() {
            return arguments;
        }

        public String description() {
            return "Restore a backed up database.";
        }

        public String summary() {
            return this.description();
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new RestoreDatabaseCli(homeDir, configDir);
        }
    }
}

