/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.backup.BackupServer;
import org.neo4j.backup.TheBackupInterface;
import org.neo4j.com.Client;
import org.neo4j.com.Deserializer;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.TargetCaller;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.ToNetworkStoreWriter;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

class BackupClient
extends Client<TheBackupInterface>
implements TheBackupInterface {
    static final long BIG_READ_TIMEOUT = TimeUnit.MINUTES.toMillis(20L);

    BackupClient(String destinationHostNameOrIp, int destinationPort, String originHostNameOrIp, LogProvider logProvider, StoreId storeId, long timeout, ResponseUnpacker unpacker, ByteCounterMonitor byteCounterMonitor, RequestMonitor requestMonitor, LogEntryReader<ReadableClosablePositionAwareChannel> reader) {
        super(destinationHostNameOrIp, destinationPort, originHostNameOrIp, logProvider, storeId, 0x400000, timeout, 20, 0x400000, unpacker, byteCounterMonitor, requestMonitor, reader);
    }

    @Override
    public Response<Void> fullBackup(StoreWriter storeWriter, final boolean forensics) {
        return this.sendRequest(BackupRequestType.FULL_BACKUP, RequestContext.EMPTY, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                buffer.writeByte(forensics ? 1 : 0);
            }
        }, (Deserializer)new Protocol.FileStreamsDeserializer310(storeWriter));
    }

    @Override
    public Response<Void> incrementalBackup(RequestContext context) {
        return this.sendRequest(BackupRequestType.INCREMENTAL_BACKUP, context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    public ProtocolVersion getProtocolVersion() {
        return BackupServer.BACKUP_PROTOCOL_VERSION;
    }

    protected boolean shouldCheckStoreId(RequestType<TheBackupInterface> type) {
        return type != BackupRequestType.FULL_BACKUP;
    }

    public static enum BackupRequestType implements RequestType<TheBackupInterface>
    {
        FULL_BACKUP((master, context, input, target) -> {
            boolean forensics = input.readable() && BackupRequestType.booleanOf(input.readByte());
            return master.fullBackup((StoreWriter)new ToNetworkStoreWriter(target, new Monitors()), forensics);
        }, Protocol.VOID_SERIALIZER),
        INCREMENTAL_BACKUP((master, context, input, target) -> master.incrementalBackup(context), Protocol.VOID_SERIALIZER);

        private final TargetCaller<?, ?> masterCaller;
        private final ObjectSerializer<?> serializer;

        private BackupRequestType(TargetCaller<?, ?> masterCaller, ObjectSerializer<?> serializer) {
            this.masterCaller = masterCaller;
            this.serializer = serializer;
        }

        private static boolean booleanOf(byte value) {
            switch (value) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            throw new IllegalArgumentException("Invalid 'boolean' byte value " + value);
        }

        public TargetCaller<?, ?> getTargetCaller() {
            return this.masterCaller;
        }

        public ObjectSerializer<?> getObjectSerializer() {
            return this.serializer;
        }

        public byte id() {
            return (byte)this.ordinal();
        }

        public boolean responseShouldBeUnpacked() {
            return false;
        }
    }
}

