/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert.internal;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.batchimport.LogFilesInitializer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.TransactionIdStore;

public class TransactionLogsInitializer
implements LogFilesInitializer {
    public static final LogFilesInitializer INSTANCE = new TransactionLogsInitializer();

    private TransactionLogsInitializer() {
    }

    public void initializeLogFiles(Config config, DatabaseLayout databaseLayout, NeoStores neoStores, FileSystemAbstraction fileSystem) {
        try {
            LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)databaseLayout, (FileSystemAbstraction)fileSystem).withTransactionIdStore((TransactionIdStore)neoStores.getMetaDataStore()).withLogVersionRepository((LogVersionRepository)neoStores.getMetaDataStore()).withStoreId(neoStores.getMetaDataStore().getStoreId()).withConfig(config).build();
            new Lifespan(new Lifecycle[]{logFiles}).close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Fail to create empty transaction log file.", (Throwable)e);
        }
    }
}

