/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert.internal;

import java.util.Iterator;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.recordstorage.RecordNodeCursor;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;

abstract class BatchRelationshipIterable<T>
implements Iterable<T> {
    private final StorageRelationshipTraversalCursor relationshipCursor;

    BatchRelationshipIterable(RecordStorageReader storageReader, long nodeId, PageCursorTracer cursorTracer) {
        this.relationshipCursor = storageReader.allocateRelationshipTraversalCursor(cursorTracer);
        RecordNodeCursor nodeCursor = storageReader.allocateNodeCursor(cursorTracer);
        nodeCursor.single(nodeId);
        if (!nodeCursor.next()) {
            throw new NotFoundException("Node " + nodeId + " not found");
        }
        this.relationshipCursor.init(nodeId, nodeCursor.relationshipsReference(), RelationshipSelection.ALL_RELATIONSHIPS);
    }

    @Override
    public Iterator<T> iterator() {
        return new PrefetchingIterator<T>(){

            protected T fetchNextOrNull() {
                if (!BatchRelationshipIterable.this.relationshipCursor.next()) {
                    return null;
                }
                return BatchRelationshipIterable.this.nextFrom(BatchRelationshipIterable.this.relationshipCursor.entityReference(), BatchRelationshipIterable.this.relationshipCursor.type(), BatchRelationshipIterable.this.relationshipCursor.sourceNodeReference(), BatchRelationshipIterable.this.relationshipCursor.targetNodeReference());
            }
        };
    }

    protected abstract T nextFrom(long var1, int var3, long var4, long var6);
}

