/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchinsert.internal;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import java.util.stream.LongStream;
import org.eclipse.collections.api.factory.Sets;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.internal.BatchRelationship;
import org.neo4j.batchinsert.internal.BatchRelationshipIterable;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.DegreesRebuildFromStore;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.counts.GBPTreeGenericCountsStore;
import org.neo4j.internal.counts.GBPTreeRelationshipGroupDegreesStore;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.IteratorWrapper;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.recordstorage.DirectRecordAccessSet;
import org.neo4j.internal.recordstorage.PropertyCreator;
import org.neo4j.internal.recordstorage.PropertyDeleter;
import org.neo4j.internal.recordstorage.PropertyTraverser;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.recordstorage.RelationshipCreator;
import org.neo4j.internal.recordstorage.RelationshipGroupGetter;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMapFactory;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.locker.DatabaseLocker;
import org.neo4j.kernel.internal.locker.Locker;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.lock.LockService;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.time.Clocks;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;

public class BatchInserterImpl
implements BatchInserter {
    private static final String BATCH_INSERTER_TAG = "batchInserter";
    private static final String CHECKPOINT_REASON = "Batch inserter checkpoint.";
    private final LifeSupport life;
    private final NeoStores neoStores;
    private final RecordDatabaseLayout databaseLayout;
    private final TokenHolders tokenHolders;
    private final IdGeneratorFactory idGeneratorFactory;
    private final IndexProviderMap indexProviderMap;
    private final Log msgLog;
    private final SchemaCache schemaCache;
    private final Config config;
    private final Locker locker;
    private final PageCache pageCache;
    private final RecordStorageReader storageReader;
    private final SimpleLogService logService;
    private final FileSystemAbstraction fileSystem;
    private final Monitors monitors;
    private final JobScheduler jobScheduler;
    private final PageCacheTracer pageCacheTracer;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;
    private final MemoryTracker memoryTracker;
    private final RelationshipGroupDegreesStore.Updater degreeUpdater;
    private final RelationshipGroupGetter relationshipGroupGetter;
    private boolean isShutdown;
    private final LongFunction<Label> labelIdToLabelFunction;
    private final FlushStrategy flushStrategy;
    private final RelationshipCreator relationshipCreator;
    private final DirectRecordAccessSet recordAccess;
    private final PropertyTraverser propertyTraverser;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeletor;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RelationshipTypeTokenStore relationshipTypeTokenStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;
    private final PropertyStore propertyStore;
    private final GBPTreeRelationshipGroupDegreesStore groupDegreesStore;
    private final FullScanStoreView fullScanStoreView;
    private final LabelTokenStore labelTokenStore;
    private final long maxNodeId;
    private final DatabaseReadOnlyChecker readOnlyChecker;

    public BatchInserterImpl(DatabaseLayout layoutArg, FileSystemAbstraction fileSystem, Config fromConfig, DatabaseTracers tracers) throws IOException {
        RecordDatabaseLayout databaseLayout = RecordDatabaseLayout.convert((DatabaseLayout)layoutArg);
        BatchInserterImpl.rejectAutoUpgrade(fromConfig);
        Neo4jLayout layout = databaseLayout.getNeo4jLayout();
        this.config = Config.newBuilder().setDefaults(BatchInserterImpl.getDefaultParams()).set(GraphDatabaseSettings.neo4j_home, (Object)layout.homeDirectory()).set(GraphDatabaseInternalSettings.databases_root_path, (Object)layout.databasesDirectory()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)layout.transactionLogsRootDirectory()).set(GraphDatabaseSettings.logs_directory, (Object)Path.of("", new String[0])).fromConfig(fromConfig).build();
        this.fileSystem = fileSystem;
        this.pageCacheTracer = tracers.getPageCacheTracer();
        this.cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(BATCH_INSERTER_TAG));
        this.memoryTracker = EmptyMemoryTracker.INSTANCE;
        this.life = new LifeSupport();
        this.databaseLayout = databaseLayout;
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        try {
            this.life.add((Lifecycle)this.jobScheduler);
            this.locker = BatchInserterImpl.tryLockStore(fileSystem, (DatabaseLayout)databaseLayout);
            ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, this.config, this.pageCacheTracer, (Log)NullLog.getInstance(), this.jobScheduler, Clocks.nanoClock(), new MemoryPools(((Boolean)this.config.get(GraphDatabaseSettings.memory_tracking)).booleanValue()));
            this.pageCache = pageCacheFactory.getOrCreatePageCache();
            this.life.add((Lifecycle)new PageCacheLifecycle(this.pageCache));
            Neo4jLoggerContext ctx = LogConfig.createBuilder((FileSystemAbstraction)fileSystem, (Path)((Path)this.config.get(GraphDatabaseSettings.store_internal_log_path)), (Level)Level.INFO).build();
            this.logService = (SimpleLogService)this.life.add((Lifecycle)new SimpleLogService(ctx));
            this.msgLog = this.logService.getInternalLog(this.getClass());
            boolean dump = (Boolean)this.config.get(GraphDatabaseInternalSettings.dump_configuration);
            this.idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem, RecoveryCleanupWorkCollector.immediate(), true, databaseLayout.getDatabaseName());
            LogProvider internalLogProvider = this.logService.getInternalLogProvider();
            RecordFormats recordFormats = RecordFormatSelector.selectForStoreOrConfig((Config)this.config, (RecordDatabaseLayout)this.databaseLayout, (FileSystemAbstraction)fileSystem, (PageCache)this.pageCache, (LogProvider)internalLogProvider, (PageCacheTracer)this.pageCacheTracer);
            this.readOnlyChecker = DatabaseReadOnlyChecker.writable();
            StoreFactory sf = new StoreFactory((DatabaseLayout)this.databaseLayout, this.config, this.idGeneratorFactory, this.pageCache, fileSystem, recordFormats, internalLogProvider, this.pageCacheTracer, this.readOnlyChecker, Sets.immutable.empty());
            this.maxNodeId = recordFormats.node().getMaxId();
            if (dump) {
                BatchInserterImpl.dumpConfiguration(this.config);
            }
            this.msgLog.info(String.valueOf(Thread.currentThread()) + " Starting BatchInserter(" + String.valueOf(this) + ")");
            this.life.start();
            this.neoStores = sf.openAllNeoStores(true);
            this.neoStores.verifyStoreOk();
            this.neoStores.start(this.cursorContext);
            this.storeCursors = new CachedStoreCursors(this.neoStores, this.cursorContext);
            this.nodeStore = this.neoStores.getNodeStore();
            this.relationshipStore = this.neoStores.getRelationshipStore();
            this.relationshipTypeTokenStore = this.neoStores.getRelationshipTypeTokenStore();
            this.propertyKeyTokenStore = this.neoStores.getPropertyKeyTokenStore();
            this.propertyStore = this.neoStores.getPropertyStore();
            RelationshipGroupStore relationshipGroupStore = this.neoStores.getRelationshipGroupStore();
            this.labelTokenStore = this.neoStores.getLabelTokenStore();
            this.groupDegreesStore = new GBPTreeRelationshipGroupDegreesStore(this.pageCache, databaseLayout.relationshipGroupDegreesStore(), fileSystem, RecoveryCleanupWorkCollector.immediate(), (GBPTreeRelationshipGroupDegreesStore.DegreesRebuilder)new DegreesRebuildFromStore(this.pageCache, this.neoStores, (DatabaseLayout)databaseLayout, this.pageCacheTracer, this.logService.getInternalLogProvider(), Configuration.DEFAULT), this.readOnlyChecker, this.pageCacheTracer, GBPTreeGenericCountsStore.NO_MONITOR, databaseLayout.getDatabaseName(), ((Integer)this.config.get(GraphDatabaseInternalSettings.counts_store_max_cached_entries)).intValue(), this.logService.getUserLogProvider());
            this.groupDegreesStore.start(this.cursorContext, this.storeCursors, this.memoryTracker);
            this.degreeUpdater = this.groupDegreesStore.directApply(this.cursorContext);
            DelegatingTokenHolder propertyKeyTokenHolder = new DelegatingTokenHolder(this::createNewPropertyKeyId, "PropertyKey");
            DelegatingTokenHolder relationshipTypeTokenHolder = new DelegatingTokenHolder(this::createNewRelationshipType, "RelationshipType");
            DelegatingTokenHolder labelTokenHolder = new DelegatingTokenHolder(this::createNewLabelId, "Label");
            this.tokenHolders = new TokenHolders((TokenHolder)propertyKeyTokenHolder, (TokenHolder)labelTokenHolder, (TokenHolder)relationshipTypeTokenHolder);
            this.tokenHolders.setInitialTokens(StoreTokens.allTokens((NeoStores)this.neoStores), this.storeCursors);
            this.labelIdToLabelFunction = from -> {
                try {
                    return Label.label((String)this.tokenHolders.labelTokens().getTokenById(Numbers.safeCastLongToInt((long)from)).name());
                }
                catch (TokenNotFoundException e) {
                    throw new RuntimeException(e);
                }
            };
            this.monitors = new Monitors();
            this.fullScanStoreView = new FullScanStoreView(LockService.NO_LOCK_SERVICE, () -> new RecordStorageReader(this.neoStores), any -> new CachedStoreCursors(this.neoStores, this.cursorContext), this.config, this.jobScheduler);
            this.indexProviderMap = (IndexProviderMap)this.life.add((Lifecycle)StaticIndexProviderMapFactory.create((LifeSupport)this.life, (Config)this.config, (PageCache)this.pageCache, (FileSystemAbstraction)fileSystem, (LogService)this.logService, (Monitors)this.monitors, (DatabaseReadOnlyChecker)this.readOnlyChecker, (DbmsInfo)DbmsInfo.TOOL, (RecoveryCleanupWorkCollector)RecoveryCleanupWorkCollector.immediate(), (PageCacheTracer)this.pageCacheTracer, (DatabaseLayout)databaseLayout, (TokenHolders)this.tokenHolders, (JobScheduler)this.jobScheduler));
            SchemaRuleAccess schemaRuleAccess = SchemaRuleAccess.getSchemaRuleAccess((SchemaStore)this.neoStores.getSchemaStore(), (TokenHolders)this.tokenHolders, (KernelVersionRepository)this.neoStores.getMetaDataStore());
            this.schemaCache = new SchemaCache((ConstraintRuleAccessor)ConstraintSemantics.getConstraintSemantics(), (IndexConfigCompleter)this.indexProviderMap);
            this.schemaCache.load(schemaRuleAccess.getAll(this.storeCursors));
            this.recordAccess = new DirectRecordAccessSet(this.neoStores, this.idGeneratorFactory, this.cursorContext);
            this.relationshipGroupGetter = new RelationshipGroupGetter((IdSequence)relationshipGroupStore, this.cursorContext);
            this.relationshipCreator = new RelationshipCreator(relationshipGroupStore.getStoreHeaderInt(), 10L, this.cursorContext);
            this.propertyTraverser = new PropertyTraverser();
            this.propertyCreator = new PropertyCreator(this.propertyStore, this.propertyTraverser, this.cursorContext, this.memoryTracker);
            this.propertyDeletor = new PropertyDeleter(this.propertyTraverser, this.neoStores, (TokenNameLookup)this.tokenHolders, this.logService.getInternalLogProvider(), this.config, this.cursorContext, this.memoryTracker, this.storeCursors);
            this.flushStrategy = new BatchedFlushStrategy(this.recordAccess, (Integer)this.config.get(GraphDatabaseInternalSettings.batch_inserter_batch_size));
            this.storageReader = new RecordStorageReader(this.neoStores);
        }
        catch (Exception e) {
            try {
                this.jobScheduler.shutdown();
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    private static Locker tryLockStore(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) {
        DatabaseLocker locker = new DatabaseLocker(fileSystem, databaseLayout);
        try {
            locker.checkLock();
        }
        catch (Exception e) {
            try {
                locker.close();
            }
            catch (IOException ce) {
                e.addSuppressed(ce);
            }
            throw e;
        }
        return locker;
    }

    private static Map<Setting<?>, Object> getDefaultParams() {
        HashMap params = new HashMap();
        params.put(GraphDatabaseSettings.pagecache_memory, "32m");
        return params;
    }

    @Override
    public boolean nodeHasProperty(long node, String propertyName) {
        return this.primitiveHasProperty((PrimitiveRecord)this.getNodeRecord(node).forChangingData(), propertyName);
    }

    @Override
    public boolean relationshipHasProperty(long relationship, String propertyName) {
        return this.primitiveHasProperty((PrimitiveRecord)this.recordAccess.getRelRecords().getOrLoad(relationship, null).forReadingData(), propertyName);
    }

    @Override
    public void setNodeProperty(long node, String propertyName, Object propertyValue) {
        RecordAccess.RecordProxy<NodeRecord, Void> nodeRecord = this.getNodeRecord(node);
        this.setPrimitiveProperty(nodeRecord, propertyName, propertyValue);
        this.flushStrategy.flush();
    }

    @Override
    public void setRelationshipProperty(long relationship, String propertyName, Object propertyValue) {
        RecordAccess.RecordProxy<RelationshipRecord, Void> relationshipRecord = this.getRelationshipRecord(relationship);
        this.setPrimitiveProperty(relationshipRecord, propertyName, propertyValue);
        this.flushStrategy.flush();
    }

    @Override
    public void removeNodeProperty(long node, String propertyName) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        this.propertyDeletor.removePropertyIfExists(this.getNodeRecord(node), propertyKey, this.recordAccess.getPropertyRecords());
        this.flushStrategy.flush();
    }

    @Override
    public void removeRelationshipProperty(long relationship, String propertyName) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        this.propertyDeletor.removePropertyIfExists(this.getRelationshipRecord(relationship), propertyKey, this.recordAccess.getPropertyRecords());
        this.flushStrategy.flush();
    }

    private void setPrimitiveProperty(RecordAccess.RecordProxy<? extends PrimitiveRecord, Void> primitiveRecord, String propertyName, Object propertyValue) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        RecordAccess propertyRecords = this.recordAccess.getPropertyRecords();
        this.propertyCreator.primitiveSetProperty(primitiveRecord, propertyKey, ValueUtils.asValue((Object)propertyValue), propertyRecords);
    }

    private void repopulateAllIndexes() throws IOException {
        LogProvider logProvider = this.logService.getInternalLogProvider();
        LogProvider userLogProvider = this.logService.getUserLogProvider();
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        IndexStoreViewFactory indexStoreViewFactory = new IndexStoreViewFactory(this.config, context -> new CachedStoreCursors(this.neoStores, context), () -> new RecordStorageReader(this.neoStores, this.schemaCache), Locks.NO_LOCKS, this.fullScanStoreView, LockService.NO_LOCK_SERVICE, logProvider);
        IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore(this.pageCache, this.databaseLayout.indexStatisticsStore(), RecoveryCleanupWorkCollector.immediate(), this.readOnlyChecker, this.databaseLayout.getDatabaseName(), cacheTracer);
        IndexingService indexingService = IndexingServiceFactory.createIndexingService((Config)this.config, (JobScheduler)this.jobScheduler, (IndexProviderMap)this.indexProviderMap, (IndexStoreViewFactory)indexStoreViewFactory, (TokenNameLookup)this.tokenHolders, Collections.emptyList(), (LogProvider)logProvider, (LogProvider)userLogProvider, (IndexMonitor)IndexMonitor.NO_MONITOR, (SchemaState)new DatabaseSchemaState(logProvider), (IndexStatisticsStore)indexStatisticsStore, (PageCacheTracer)cacheTracer, (MemoryTracker)this.memoryTracker, (String)this.databaseLayout.getDatabaseName(), (DatabaseReadOnlyChecker)this.readOnlyChecker);
        this.life.add((Lifecycle)indexingService);
        try {
            IndexDescriptor[] descriptors = this.getIndexesNeedingPopulation(this.cursorContext);
            indexingService.createIndexes(true, Subject.AUTH_DISABLED, descriptors);
            for (IndexDescriptor descriptor : descriptors) {
                IndexProxy indexProxy = BatchInserterImpl.getIndexProxy(indexingService, descriptor);
                try {
                    indexProxy.awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
                }
                catch (IndexPopulationFailedKernelException indexPopulationFailedKernelException) {
                    // empty catch block
                }
            }
            indexingService.forceAll(this.cursorContext);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static IndexProxy getIndexProxy(IndexingService indexingService, IndexDescriptor index) {
        try {
            return indexingService.getIndexProxy(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException("Expected index by descriptor " + String.valueOf(index) + " to exist, but didn't", e);
        }
    }

    private void rebuildCounts(PageCacheTracer cacheTracer, MemoryTracker memoryTracker) throws IOException {
        Path countsStoreFile = this.databaseLayout.countStore();
        if (this.fileSystem.fileExists(countsStoreFile)) {
            this.fileSystem.deleteFile(countsStoreFile);
        }
        CountsComputer initialCountsBuilder = new CountsComputer(this.neoStores, this.pageCache, cacheTracer, (DatabaseLayout)this.databaseLayout, memoryTracker, this.logService.getInternalLog(this.getClass()));
        try (GBPTreeCountsStore countsStore = new GBPTreeCountsStore(this.pageCache, this.databaseLayout.countStore(), this.fileSystem, RecoveryCleanupWorkCollector.immediate(), (CountsBuilder)initialCountsBuilder, this.readOnlyChecker, cacheTracer, GBPTreeGenericCountsStore.NO_MONITOR, this.databaseLayout.getDatabaseName(), ((Integer)this.config.get(GraphDatabaseInternalSettings.counts_store_max_cached_entries)).intValue(), this.logService.getUserLogProvider());
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.neoStores, CursorContext.NULL);){
            countsStore.start(CursorContext.NULL, (StoreCursors)storeCursors, memoryTracker);
            countsStore.checkpoint(CursorContext.NULL);
        }
    }

    private void createEmptyTransactionLog() {
        TransactionLogInitializer.getLogFilesInitializer().initializeLogFiles((DatabaseLayout)this.databaseLayout, (MetadataProvider)this.neoStores.getMetaDataStore(), this.fileSystem, CHECKPOINT_REASON);
    }

    private IndexDescriptor[] getIndexesNeedingPopulation(CursorContext cursorContext) {
        ArrayList<IndexDescriptor> indexesNeedingPopulation = new ArrayList<IndexDescriptor>();
        for (IndexDescriptor descriptor : this.schemaCache.indexes()) {
            IndexProvider provider = this.indexProviderMap.lookup(descriptor.getIndexProvider());
            if (provider.getInitialState(descriptor, cursorContext) == InternalIndexState.FAILED) continue;
            indexesNeedingPopulation.add(descriptor);
        }
        return indexesNeedingPopulation.toArray(new IndexDescriptor[0]);
    }

    private static TransactionFailureException kernelExceptionToUserException(KernelException e) {
        throw new TransactionFailureException("Unexpected kernel exception writing schema rules", (Throwable)e);
    }

    private static int silentGetOrCreateTokenId(TokenHolder tokens, String name) {
        try {
            return tokens.getOrCreateId(name);
        }
        catch (KernelException e) {
            throw BatchInserterImpl.kernelExceptionToUserException(e);
        }
    }

    private int getOrCreatePropertyKeyId(String name) {
        return BatchInserterImpl.silentGetOrCreateTokenId(this.tokenHolders.propertyKeyTokens(), name);
    }

    private int getOrCreateRelationshipTypeId(String name) {
        return BatchInserterImpl.silentGetOrCreateTokenId(this.tokenHolders.relationshipTypeTokens(), name);
    }

    private int getOrCreateLabelId(String name) {
        return BatchInserterImpl.silentGetOrCreateTokenId(this.tokenHolders.labelTokens(), name);
    }

    private boolean primitiveHasProperty(PrimitiveRecord record, String propertyName) {
        int propertyKeyId = this.tokenHolders.propertyKeyTokens().getIdByName(propertyName);
        return propertyKeyId != -1 && this.propertyTraverser.findPropertyRecordContaining(record, propertyKeyId, this.recordAccess.getPropertyRecords(), false) != (long)Record.NO_NEXT_PROPERTY.intValue();
    }

    private static void rejectAutoUpgrade(Config config) {
        if (((Boolean)config.get(GraphDatabaseSettings.allow_upgrade)).booleanValue()) {
            throw new IllegalArgumentException("Batch inserter is not allowed to do upgrade of a store.");
        }
    }

    @Override
    public long createNode(Map<String, Object> properties, Label ... labels) {
        return this.internalCreateNode(this.nodeStore.nextId(this.cursorContext), properties, labels);
    }

    private long internalCreateNode(long nodeId, Map<String, Object> properties, Label ... labels) {
        NodeRecord nodeRecord = (NodeRecord)this.recordAccess.getNodeRecords().create(nodeId, null, this.cursorContext).forChangingData();
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
        nodeRecord.setNextProp(this.propertyCreator.createPropertyChain((PrimitiveRecord)nodeRecord, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        if (labels.length > 0) {
            this.setNodeLabels(nodeRecord, labels);
        }
        this.flushStrategy.flush();
        return nodeId;
    }

    private Iterator<PropertyBlock> propertiesIterator(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return Collections.emptyIterator();
        }
        return new IteratorWrapper<PropertyBlock, Map.Entry<String, Object>>(properties.entrySet().iterator()){

            protected PropertyBlock underlyingObjectToObject(Map.Entry<String, Object> property) {
                return BatchInserterImpl.this.propertyCreator.encodePropertyValue(BatchInserterImpl.this.getOrCreatePropertyKeyId(property.getKey()), ValueUtils.asValue((Object)property.getValue()));
            }
        };
    }

    private void setNodeLabels(NodeRecord nodeRecord, Label ... labels) {
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord);
        nodeLabels.put(this.getOrCreateLabelIds(labels), this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore(), this.cursorContext, this.storeCursors, this.memoryTracker);
    }

    private long[] getOrCreateLabelIds(Label[] labels) {
        long[] ids = new long[labels.length];
        int cursor = 0;
        for (int i = 0; i < ids.length; ++i) {
            int labelId = this.getOrCreateLabelId(labels[i].name());
            if (BatchInserterImpl.arrayContains(ids, cursor, labelId)) continue;
            ids[cursor++] = labelId;
        }
        if (cursor < ids.length) {
            ids = Arrays.copyOf(ids, cursor);
        }
        return ids;
    }

    private static boolean arrayContains(long[] ids, int cursor, int labelId) {
        for (int i = 0; i < cursor; ++i) {
            if (ids[i] != (long)labelId) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createNode(long id, Map<String, Object> properties, Label ... labels) {
        IdValidator.assertValidId((IdType)RecordIdType.NODE, (long)id, (long)this.maxNodeId);
        PageCursor nodeCursor = this.storeCursors.readCursor((CursorType)RecordCursorTypes.NODE_CURSOR);
        if (this.nodeStore.isInUse(id, nodeCursor)) {
            throw new IllegalArgumentException("id=" + id + " already in use");
        }
        long highId = this.nodeStore.getHighId();
        if (highId <= id) {
            this.nodeStore.setHighestPossibleIdInUse(id);
        }
        this.internalCreateNode(id, properties, labels);
    }

    @Override
    public void setNodeLabels(long node, Label ... labels) {
        NodeRecord record = (NodeRecord)this.getNodeRecord(node).forChangingData();
        this.setNodeLabels(record, labels);
        this.flushStrategy.flush();
    }

    @Override
    public Iterable<Label> getNodeLabels(long node) {
        return () -> {
            NodeRecord record = (NodeRecord)this.getNodeRecord(node).forReadingData();
            long[] labels = NodeLabelsField.parseLabelsField((NodeRecord)record).get(this.nodeStore, this.storeCursors);
            return LongStream.of(labels).mapToObj(this.labelIdToLabelFunction).iterator();
        };
    }

    @Override
    public boolean nodeHasLabel(long node, Label label) {
        int labelId = this.tokenHolders.labelTokens().getIdByName(label.name());
        return labelId != -1 && this.nodeHasLabel(node, labelId);
    }

    private boolean nodeHasLabel(long node, int labelId) {
        NodeRecord record = (NodeRecord)this.getNodeRecord(node).forReadingData();
        for (long label : NodeLabelsField.parseLabelsField((NodeRecord)record).get(this.nodeStore, this.storeCursors)) {
            if (label != (long)labelId) continue;
            return true;
        }
        return false;
    }

    @Override
    public long createRelationship(long node1, long node2, RelationshipType type, Map<String, Object> properties) {
        long id = this.relationshipStore.nextId(this.cursorContext);
        int typeId = this.getOrCreateRelationshipTypeId(type.name());
        this.relationshipCreator.relationshipCreate(id, typeId, node1, node2, (RecordAccessSet)this.recordAccess, this.degreeUpdater, (RelationshipCreator.NodeDataLookup)new RelationshipCreator.InsertFirst(this.relationshipGroupGetter, (RecordAccessSet)this.recordAccess, this.cursorContext));
        if (properties != null && !properties.isEmpty()) {
            RelationshipRecord record = (RelationshipRecord)this.recordAccess.getRelRecords().getOrLoad(id, null).forChangingData();
            record.setNextProp(this.propertyCreator.createPropertyChain((PrimitiveRecord)record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        }
        this.flushStrategy.flush();
        return id;
    }

    @Override
    public void setNodeProperties(long node, Map<String, Object> properties) {
        NodeRecord record = (NodeRecord)this.getNodeRecord(node).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.propertyDeletor.deletePropertyChain((PrimitiveRecord)record, this.recordAccess.getPropertyRecords());
        }
        record.setNextProp(this.propertyCreator.createPropertyChain((PrimitiveRecord)record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        this.flushStrategy.flush();
    }

    @Override
    public void setRelationshipProperties(long rel, Map<String, Object> properties) {
        RelationshipRecord record = (RelationshipRecord)this.recordAccess.getRelRecords().getOrLoad(rel, null).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.propertyDeletor.deletePropertyChain((PrimitiveRecord)record, this.recordAccess.getPropertyRecords());
        }
        record.setNextProp(this.propertyCreator.createPropertyChain((PrimitiveRecord)record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        this.flushStrategy.flush();
    }

    @Override
    public boolean nodeExists(long nodeId) {
        this.flushStrategy.forceFlush();
        return this.nodeStore.isInUse(nodeId, this.storeCursors.readCursor((CursorType)RecordCursorTypes.NODE_CURSOR));
    }

    @Override
    public Map<String, Object> getNodeProperties(long nodeId) {
        NodeRecord record = (NodeRecord)this.getNodeRecord(nodeId).forReadingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public Iterable<Long> getRelationshipIds(long nodeId) {
        this.flushStrategy.forceFlush();
        return new BatchRelationshipIterable<Long>(this.storageReader, nodeId, this.cursorContext, this.storeCursors){

            @Override
            protected Long nextFrom(long relId, int type, long startNode, long endNode) {
                return relId;
            }
        };
    }

    @Override
    public Iterable<BatchRelationship> getRelationships(long nodeId) {
        this.flushStrategy.forceFlush();
        return new BatchRelationshipIterable<BatchRelationship>(this.storageReader, nodeId, this.cursorContext, this.storeCursors){

            @Override
            protected BatchRelationship nextFrom(long relId, int type, long startNode, long endNode) {
                return BatchInserterImpl.this.batchRelationshipOf(relId, type, startNode, endNode);
            }
        };
    }

    private BatchRelationship batchRelationshipOf(long id, int type, long startNode, long endNode) {
        try {
            return new BatchRelationship(id, startNode, endNode, RelationshipType.withName((String)this.tokenHolders.relationshipTypeTokens().getTokenById(type).name()));
        }
        catch (TokenNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BatchRelationship getRelationshipById(long relId) {
        RelationshipRecord record = (RelationshipRecord)this.getRelationshipRecord(relId).forReadingData();
        return this.batchRelationshipOf(relId, record.getType(), record.getFirstNode(), record.getSecondNode());
    }

    @Override
    public Map<String, Object> getRelationshipProperties(long relId) {
        RelationshipRecord record = (RelationshipRecord)this.recordAccess.getRelRecords().getOrLoad(relId, null).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public void shutdown() {
        if (this.isShutdown) {
            throw new IllegalStateException("Batch inserter already has shutdown");
        }
        this.isShutdown = true;
        this.flushStrategy.forceFlush();
        this.degreeUpdater.close();
        try (CursorContext cursorContext = this.cursorContext;
             Lifespan ignore = new Lifespan(new Lifecycle[]{this.life});
             Locker locker = this.locker;
             NeoStores neoStores = this.neoStores;
             GBPTreeRelationshipGroupDegreesStore gBPTreeRelationshipGroupDegreesStore = this.groupDegreesStore;
             StoreCursors storeCursors = this.storeCursors;){
            this.repopulateAllIndexes();
            this.idGeneratorFactory.visit(IdGenerator::markHighestWrittenAtHighId);
            this.neoStores.flush(this.cursorContext);
            this.groupDegreesStore.checkpoint(this.cursorContext);
            this.recordAccess.close();
            this.createEmptyTransactionLog();
            this.rebuildCounts(this.pageCacheTracer, this.memoryTracker);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.msgLog.info(String.valueOf(Thread.currentThread()) + " Clean shutdown on BatchInserter(" + String.valueOf(this) + ")");
    }

    public String toString() {
        return "EmbeddedBatchInserter[" + String.valueOf(this.databaseLayout) + "]";
    }

    private Map<String, Object> getPropertyChain(long nextProp) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.propertyTraverser.getPropertyChain(nextProp, this.recordAccess.getPropertyRecords(), propBlock -> {
            try {
                String key = this.tokenHolders.propertyKeyTokens().getTokenById(propBlock.getKeyIndexId()).name();
                Value propertyValue = propBlock.newPropertyValue(this.propertyStore, this.storeCursors);
                map.put(key, propertyValue.asObject());
            }
            catch (TokenNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        return map;
    }

    private int createNewPropertyKeyId(String stringKey, boolean internal) {
        try (PageCursor keyTokenCursor = this.storeCursors.writeCursor((CursorType)RecordCursorTypes.PROPERTY_KEY_TOKEN_CURSOR);){
            int n = this.createNewToken((TokenStore)this.propertyKeyTokenStore, stringKey, internal, keyTokenCursor, this.storeCursors);
            return n;
        }
    }

    private int createNewLabelId(String stringKey, boolean internal) {
        try (PageCursor labelTokenCursor = this.storeCursors.writeCursor((CursorType)RecordCursorTypes.LABEL_TOKEN_CURSOR);){
            int n = this.createNewToken((TokenStore)this.labelTokenStore, stringKey, internal, labelTokenCursor, this.storeCursors);
            return n;
        }
    }

    private int createNewRelationshipType(String name, boolean internal) {
        try (PageCursor relTypeToken = this.storeCursors.writeCursor((CursorType)RecordCursorTypes.REL_TYPE_TOKEN_CURSOR);){
            int n = this.createNewToken((TokenStore)this.relationshipTypeTokenStore, name, internal, relTypeToken, this.storeCursors);
            return n;
        }
    }

    private <R extends TokenRecord> int createNewToken(TokenStore<R> store, String name, boolean internal, PageCursor writeCursor, StoreCursors storeCursors) {
        int keyId = (int)store.nextId(this.cursorContext);
        TokenRecord record = (TokenRecord)store.newRecord();
        record.setId((long)keyId);
        record.setInUse(true);
        record.setInternal(internal);
        record.setCreated();
        Collection keyRecords = store.allocateNameRecords(PropertyStore.encodeString((String)name), this.cursorContext, this.memoryTracker);
        record.setNameId((int)((DynamicRecord)Iterables.first((Iterable)keyRecords)).getId());
        record.addNameRecords((Iterable)keyRecords);
        store.updateRecord((AbstractBaseRecord)record, writeCursor, this.cursorContext, storeCursors);
        return keyId;
    }

    private RecordAccess.RecordProxy<NodeRecord, Void> getNodeRecord(long id) {
        if (id < 0L || id >= this.nodeStore.getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.recordAccess.getNodeRecords().getOrLoad(id, null);
    }

    private RecordAccess.RecordProxy<RelationshipRecord, Void> getRelationshipRecord(long id) {
        if (id < 0L || id >= this.relationshipStore.getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.recordAccess.getRelRecords().getOrLoad(id, null);
    }

    @Override
    public String getStoreDir() {
        return this.databaseLayout.databaseDirectory().toString();
    }

    private static void dumpConfiguration(Config config) {
        System.out.print(config.toString());
    }

    @VisibleForTesting
    NeoStores getNeoStores() {
        return this.neoStores;
    }

    void forceFlushChanges() {
        this.flushStrategy.forceFlush();
    }

    static final class BatchedFlushStrategy
    implements FlushStrategy {
        private final DirectRecordAccessSet directRecordAccess;
        private final int batchSize;
        private int attempts;

        BatchedFlushStrategy(DirectRecordAccessSet directRecordAccess, int batchSize) {
            this.directRecordAccess = directRecordAccess;
            this.batchSize = batchSize;
        }

        @Override
        public void flush() {
            ++this.attempts;
            if (this.attempts >= this.batchSize) {
                this.forceFlush();
            }
        }

        @Override
        public void forceFlush() {
            this.directRecordAccess.commit();
            this.attempts = 0;
        }
    }

    static interface FlushStrategy {
        public void flush();

        public void forceFlush();
    }
}

