/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.reader;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.internal.helpers.TimeUtil;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.DateTimeValue;

public final class DateTimeReader<CTX>
implements StructReader<CTX, DateTimeValue> {
    private static final DateTimeReader<?> INSTANCE = new DateTimeReader();

    private DateTimeReader() {
    }

    public static <CTX> DateTimeReader<CTX> getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return StructType.DATE_TIME.getTag();
    }

    @Override
    public DateTimeValue read(CTX ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        Instant instant;
        ZoneOffset offset;
        if (header.length() != 3L) {
            throw new IllegalStructSizeException(3L, header.length());
        }
        long epochSecond = buffer.readInt();
        long nanos = buffer.readInt();
        long offsetSeconds = buffer.readInt();
        if (nanos > Integer.MAX_VALUE || nanos < Integer.MIN_VALUE) {
            throw IllegalStructArgumentException.wrongTypeForFieldNameOrOutOfRange("nanoseconds", "INTEGER", Integer.MIN_VALUE, Integer.MAX_VALUE, nanos, "Value is out of bounds");
        }
        if (offsetSeconds > Integer.MAX_VALUE || offsetSeconds < Integer.MIN_VALUE) {
            throw IllegalStructArgumentException.wrongTypeForFieldNameOrOutOfRange("tz_offset_seconds", "INTEGER", Integer.MIN_VALUE, Integer.MAX_VALUE, offsetSeconds, "Value is out of bounds");
        }
        try {
            offset = TimeUtil.zoneOffsetOfTotalSeconds((int)((int)offsetSeconds));
            instant = Instant.ofEpochSecond(epochSecond, nanos);
        }
        catch (ArithmeticException | DateTimeException ex) {
            throw new IllegalStructArgumentException("seconds", String.format("Illegal epoch adjustment epoch seconds: %d+%d", epochSecond, nanos), (Throwable)ex);
        }
        return DateTimeValue.datetime((OffsetDateTime)OffsetDateTime.ofInstant(instant, offset));
    }
}

