/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.transition.transaction.streaming;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.error.state.IllegalRequestParameterException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.protocol.common.fsm.error.TransactionStateTransitionException;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.TransactionalStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.streaming.AutocommitStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.streaming.DiscardResultsStreamingStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.streaming.PullResultsStreamingStateTransition;
import org.neo4j.bolt.protocol.common.message.request.streaming.AbstractStreamingMessage;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.bolt.tx.statement.Statement;

public abstract sealed class StreamingStateTransition<R extends AbstractStreamingMessage>
extends TransactionalStateTransition<R>
permits AutocommitStateTransition, DiscardResultsStreamingStateTransition, PullResultsStreamingStateTransition {
    protected StreamingStateTransition(Class<R> requestType) {
        super(requestType);
    }

    @Override
    protected StateReference process(Context ctx, Transaction tx, R message, ResponseHandler handler) throws StateMachineException {
        long statementId = ((AbstractStreamingMessage)message).statementId() == -1L ? tx.latestStatementId() : ((AbstractStreamingMessage)message).statementId();
        Statement statement = tx.getStatement(statementId).orElseThrow(() -> new IllegalRequestParameterException("No such statement: " + statementId));
        return this.process(ctx, tx, statement, message, handler);
    }

    protected StateReference process(Context ctx, Transaction tx, Statement statement, R message, ResponseHandler handler) throws StateMachineException {
        try {
            this.process(ctx, tx, statement, ((AbstractStreamingMessage)message).n(), handler);
        }
        catch (TransactionException ex) {
            throw new TransactionStateTransitionException(ex);
        }
        finally {
            if (!statement.hasRemaining()) {
                statement.close();
            }
        }
        return ctx.state();
    }

    protected abstract void process(Context var1, Transaction var2, Statement var3, long var4, ResponseHandler var6) throws StateMachineException, TransactionException;
}

