/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.unix.DomainSocketAddress;
import java.io.IOException;
import java.net.BindException;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.connection.BoltDriverMetricsMonitor;
import org.neo4j.bolt.protocol.common.connection.hint.ConnectionHintRegistry;
import org.neo4j.bolt.protocol.common.connector.accounting.error.ErrorAccountant;
import org.neo4j.bolt.protocol.common.connector.accounting.traffic.NoopTrafficAccountant;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.netty.AbstractNettyConnector;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.configuration.helpers.PortBindException;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.ssl.config.ScopedSslPolicyProvider;
import org.neo4j.util.Preconditions;

public class DomainSocketNettyConnector
extends AbstractNettyConnector<DomainSocketConfiguration> {
    private final Path path;
    private final ConnectorTransport transport;

    public DomainSocketNettyConnector(String id, Path path, MemoryPool memoryPool, Clock clock, ByteBufAllocator allocator, EventLoopGroup bossGroup, EventLoopGroup workerGroup, ConnectorTransport transport, Connection.Factory connectionFactory, NetworkConnectionTracker connectionTracker, BoltProtocolRegistry protocolRegistry, Authentication authentication, AuthConfigProvider authConfigProvider, DefaultDatabaseResolver defaultDatabaseResolver, ConnectionHintRegistry connectionHintRegistry, TransactionManager transactionManager, RoutingService routingService, ErrorAccountant errorAccountant, BoltDriverMetricsMonitor driverMetricsMonitor, DomainSocketConfiguration configuration, InternalLogProvider userLogProvider, InternalLogProvider logging) {
        super(id, (SocketAddress)new DomainSocketAddress(path.toFile()), memoryPool, clock, allocator, bossGroup, workerGroup, connectionFactory, connectionTracker, protocolRegistry, authentication, authConfigProvider, defaultDatabaseResolver, connectionHintRegistry, transactionManager, routingService, errorAccountant, NoopTrafficAccountant.getInstance(), driverMetricsMonitor, configuration, userLogProvider, logging);
        Preconditions.checkArgument((transport.getDomainSocketChannelType() != null ? 1 : 0) != 0, (String)("Unsupported transport: " + transport.getName() + " does not support domain sockets"));
        this.path = path;
        this.transport = transport;
    }

    @Override
    protected Class<? extends ServerChannel> channelType() {
        return this.transport.getDomainSocketChannelType();
    }

    @Override
    protected void onStart() throws Exception {
        super.onStart();
        if (Files.exists(this.path, new LinkOption[0])) {
            if (!((DomainSocketConfiguration)this.configuration()).deleteSocketFile()) {
                throw new PortBindException(this.bindAddress, (Throwable)new BindException("Loopback listen file: " + String.valueOf(this.path) + " already exists."));
            }
            try {
                Files.deleteIfExists(this.path);
            }
            catch (IOException ex) {
                throw new PortBindException(this.bindAddress, (Throwable)ex);
            }
        }
    }

    @Override
    protected void logStartupMessage() {
        this.userLog.info("Bolt (loopback) enabled on file %s", new Object[]{this.path});
    }

    public static class DomainSocketConfiguration
    extends AbstractNettyConnector.NettyConfiguration {
        private final boolean deleteSocketFile;

        public DomainSocketConfiguration(boolean enableProtocolCapture, Path protocolCapturePath, boolean enableProtocolLogging, BoltConnectorInternalSettings.ProtocolLoggingMode protocolLoggingMode, long maxAuthenticationInboundBytes, int maxAuthenticationStructureElements, int maxAuthenticationStructureDepth, boolean enableOutboundBufferThrottle, int outboundBufferThrottleLowWatermark, int outboundBufferThrottleHighWatermark, Duration outboundBufferThrottleDuration, int inboundBufferThrottleLowWatermark, int inboundBufferThrottleHighWatermark, int streamingBufferSize, int streamingFlushThreshold, Duration connectionShutdownDuration, boolean enableTransactionThreadBinding, Duration threadBindingTimeout, boolean enableMergeCumulator, boolean deleteSocketFile) {
            super(enableProtocolCapture, protocolCapturePath, enableProtocolLogging, protocolLoggingMode, maxAuthenticationInboundBytes, maxAuthenticationStructureElements, maxAuthenticationStructureDepth, enableOutboundBufferThrottle, outboundBufferThrottleLowWatermark, outboundBufferThrottleHighWatermark, outboundBufferThrottleDuration, inboundBufferThrottleLowWatermark, inboundBufferThrottleHighWatermark, streamingBufferSize, streamingFlushThreshold, connectionShutdownDuration, enableTransactionThreadBinding, threadBindingTimeout, null, enableMergeCumulator, false, ScopedSslPolicyProvider.getNullInstance());
            this.deleteSocketFile = deleteSocketFile;
        }

        public boolean deleteSocketFile() {
            return this.deleteSocketFile;
        }
    }
}

