/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.error.reader;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.error.reader.PackstreamReaderException;

public class LimitExceededException
extends PackstreamReaderException
implements Status.HasStatus,
ErrorGqlStatusObject {
    private final long limit;
    private final long actual;

    protected LimitExceededException(ErrorGqlStatusObject gqlStatusObject, long limit, long actual) {
        super(gqlStatusObject, ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)("Value of size " + actual + " exceeded limit of " + limit)));
        this.limit = limit;
        this.actual = actual;
    }

    public static LimitExceededException protocolMessageLengthLimitOverflow(long limit, long actual) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N56).withParam(GqlParams.NumberParam.boltMsgLenLimit, (Number)limit).build();
        return new LimitExceededException(gql, limit, actual);
    }

    public long getLimit() {
        return this.limit;
    }

    public long getActual() {
        return this.actual;
    }

    public Status status() {
        return Status.Request.Invalid;
    }
}

