/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.negotiation.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.util.Set;
import org.neo4j.bolt.negotiation.handler.LegacyProtocolHandshakeHandler;
import org.neo4j.bolt.negotiation.handler.ModernProtocolHandshakeHandler;
import org.neo4j.bolt.negotiation.message.ProtocolCapability;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.codec.BoltStructEncoder;
import org.neo4j.bolt.protocol.common.connector.config.NettyConnectorConfiguration;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.netty.AbstractNettyConnector;
import org.neo4j.bolt.protocol.common.handler.HouseKeeperHandler;
import org.neo4j.bolt.protocol.common.handler.ProtocolLoggingHandler;
import org.neo4j.bolt.protocol.common.handler.RequestHandler;
import org.neo4j.bolt.protocol.common.handler.StateSignalFilterHandler;
import org.neo4j.bolt.protocol.common.handler.messages.GoodbyeMessageHandler;
import org.neo4j.bolt.protocol.common.message.response.ResponseMessage;
import org.neo4j.bolt.runtime.throttle.ChannelReadThrottleHandler;
import org.neo4j.bolt.runtime.throttle.ChannelWriteThrottleHandler;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.packstream.codec.PackstreamStructDecoder;
import org.neo4j.packstream.codec.PackstreamStructEncoder;
import org.neo4j.packstream.codec.transport.ChunkFrameDecoder;
import org.neo4j.packstream.codec.transport.ChunkFrameEncoder;
import org.neo4j.packstream.codec.transport.FrameSignalEncoder;

public abstract sealed class AbstractProtocolHandshakeHandler<I>
extends SimpleChannelInboundHandler<I>
permits ModernProtocolHandshakeHandler, LegacyProtocolHandshakeHandler {
    protected final InternalLogProvider logging;
    protected final InternalLog log;
    protected AbstractNettyConnector<?> connector;
    protected Connection connection;

    protected AbstractProtocolHandshakeHandler(InternalLogProvider logging) {
        this.logging = logging;
        this.log = logging.getLog(((Object)((Object)this)).getClass());
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.connection = Connection.getConnection(ctx.channel());
        this.connector = (AbstractNettyConnector)this.connection.connector();
    }

    public final void finalizeHandshake(ChannelHandlerContext ctx, BoltProtocol protocol, Set<ProtocolCapability> capabilities) {
        ChunkFrameDecoder frameDecoder;
        long readLimit;
        this.connection.selectProtocol(protocol, capabilities);
        this.onVersionSelected(ctx, protocol);
        ctx.pipeline().addLast(new ChannelHandler[]{new StateSignalFilterHandler()}).addLast(new ChannelHandler[]{new FrameSignalEncoder(protocol.frameSignalFilter())});
        NettyConnectorConfiguration config = (NettyConnectorConfiguration)this.connector.configuration();
        if (config.enableOutboundBufferThrottle()) {
            ctx.channel().config().setWriteBufferWaterMark(new WriteBufferWaterMark(config.outboundBufferThrottleLowWatermark(), config.outboundBufferThrottleHighWatermark()));
        }
        if ((readLimit = config.maxAuthenticationInboundBytes()) != 0L) {
            this.log.debug("Imposing %d byte read-limit on connection '%s' until authentication is completed", new Object[]{readLimit, this.connection.id()});
            frameDecoder = new ChunkFrameDecoder(readLimit, this.logging);
        } else {
            frameDecoder = new ChunkFrameDecoder(this.logging);
        }
        if (config.enableMergeCumulator()) {
            this.log.warn("Enabling merge cumulator for chunk decoding - Network performance may be degraded");
            frameDecoder.setCumulator(ByteToMessageDecoder.MERGE_CUMULATOR);
        }
        ctx.pipeline().addLast("chunkFrameDecoder", (ChannelHandler)frameDecoder);
        if (config.enableProtocolLogging() && config.protocolLoggingMode().isLoggingRawTraffic()) {
            ctx.pipeline().remove("rawProtocolLoggingHandler");
            ctx.pipeline().addLast("rawProtocolLoggingHandler", (ChannelHandler)new ProtocolLoggingHandler(this.logging));
        }
        ctx.pipeline().addLast("chunkFrameEncoder", (ChannelHandler)new ChunkFrameEncoder()).addLast("structDecoder", new PackstreamStructDecoder<Connection>(this.connection, protocol.requestMessageRegistry(), this.logging)).addLast("structEncoder", new PackstreamStructEncoder<Connection, ResponseMessage>(ResponseMessage.class, this.connection, protocol.responseMessageRegistry()));
        int inboundMessageThrottleHighWatermark = config.inboundBufferThrottleHighWatermark();
        if (inboundMessageThrottleHighWatermark != 0) {
            ctx.pipeline().addLast("readThrottleHandler", (ChannelHandler)new ChannelReadThrottleHandler(config.inboundBufferThrottleLowWatermark(), inboundMessageThrottleHighWatermark, this.logging));
        }
        if (config.enableProtocolLogging() && config.protocolLoggingMode().isLoggingDecodedTraffic()) {
            ctx.pipeline().remove("decodedProtocolLoggingHandler");
            ctx.pipeline().addLast("decodedProtocolLoggingHandler", (ChannelHandler)new ProtocolLoggingHandler(this.logging));
        }
        ctx.pipeline().addLast("goodbyeMessageHandler", (ChannelHandler)new GoodbyeMessageHandler(this.logging)).addLast("boltStructEncoder", (ChannelHandler)new BoltStructEncoder());
        boolean writeThrottleEnabled = config.enableOutboundBufferThrottle();
        long writeTimeoutMillis = config.outboundBufferMaxThrottleDuration().toMillis();
        if (writeThrottleEnabled && writeTimeoutMillis != 0L) {
            ctx.pipeline().addLast("channelThrottleHandler", (ChannelHandler)new ChannelWriteThrottleHandler(writeTimeoutMillis, this.logging));
        }
        ctx.pipeline().addLast("requestHandler", (ChannelHandler)new RequestHandler(this.logging)).addLast("housekeeper", (ChannelHandler)new HouseKeeperHandler(this.logging));
        this.removeStageHandlers(ctx);
        this.connection.notifyListeners(listener -> listener.onProtocolSelected(protocol));
    }

    protected void onVersionSelected(ChannelHandlerContext ctx, BoltProtocol protocol) {
    }

    protected void removeStageHandlers(ChannelHandlerContext ctx) {
        ctx.pipeline().remove((ChannelHandler)this);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof DecoderException) {
            this.log.debug("Failed Bolt handshake: Malformed negotiation payload received.", cause);
        } else {
            this.log.error("Fatal error occurred during protocol handshaking: " + String.valueOf(ctx.channel()), cause);
        }
        ctx.close();
    }
}

