/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.config;

import java.nio.file.Path;
import java.time.Duration;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;

public interface ConnectorConfiguration {
    public boolean enableProtocolCapture();

    public Path protocolCapturePath();

    public boolean enableProtocolLogging();

    public BoltConnectorInternalSettings.ProtocolLoggingMode protocolLoggingMode();

    public long maxAuthenticationInboundBytes();

    public int maxAuthenticationStructureElements();

    public int maxAuthenticationStructureDepth();

    public boolean enableOutboundBufferThrottle();

    public int outboundBufferThrottleLowWatermark();

    public int outboundBufferThrottleHighWatermark();

    public Duration outboundBufferMaxThrottleDuration();

    public int inboundBufferThrottleLowWatermark();

    public int inboundBufferThrottleHighWatermark();

    public int streamingBufferSize();

    public int streamingFlushThreshold();

    public Duration connectionShutdownDuration();

    public boolean enableTransactionThreadBinding();

    public Duration threadBindingTimeout();

    public static interface Factory<SELF extends Factory<SELF>> {
        public ConnectorConfiguration build();

        public SELF fromConfig(Config var1);

        public SELF enableProtocolCapture(boolean var1);

        public SELF protocolCapturePath(Path var1);

        default public SELF enableProtocolLogging(BoltConnectorInternalSettings.ProtocolLoggingMode mode) {
            return this.enableProtocolLogging(true).protocolLoggingMode(mode);
        }

        public SELF enableProtocolLogging(boolean var1);

        public SELF protocolLoggingMode(BoltConnectorInternalSettings.ProtocolLoggingMode var1);

        public SELF maxAuthenticationInboundBytes(long var1);

        public SELF maxAuthenticationStructureElements(int var1);

        public SELF maxAuthenticationStructureDepth(int var1);

        public SELF enableOutboundBufferThrottle(boolean var1);

        public SELF outboundBufferThrottleLowWatermark(int var1);

        public SELF outboundBufferThrottleHighWatermark(int var1);

        public SELF outboundBufferMaxThrottleDuration(Duration var1);

        default public SELF enableInboundBufferThrottle(int lowWatermark, int highWatermark) {
            return this.inboundBufferThrottleLowWatermark(lowWatermark).inboundBufferThrottleHighWatermark(highWatermark);
        }

        public SELF inboundBufferThrottleLowWatermark(int var1);

        public SELF inboundBufferThrottleHighWatermark(int var1);

        public SELF streamingBufferSize(int var1);

        public SELF streamingFlushThreshold(int var1);

        public SELF connectionShutdownDuration(Duration var1);

        public SELF enableTransactionThreadBinding(boolean var1);

        public SELF threadBindingTimeout(Duration var1);
    }
}

