/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.config;

import java.util.function.Consumer;
import org.neo4j.bolt.protocol.common.connector.config.AbstractExternalConnectorConfiguration;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.util.Preconditions;

public final class SocketConnectorConfiguration
extends AbstractExternalConnectorConfiguration {
    private final boolean enableTcpKeepAlive;
    private final boolean enableTcpFastOpen;
    private final int tcpFastOpenMaxPendingConnections;

    private SocketConnectorConfiguration(Factory builder) {
        super(builder);
        this.enableTcpKeepAlive = builder.enableTcpKeepAlive;
        this.enableTcpFastOpen = builder.enableTcpFastOpen;
        this.tcpFastOpenMaxPendingConnections = builder.tcpFastOpenMaxPendingConnections;
    }

    public static Factory factory() {
        return new Factory();
    }

    public static SocketConnectorConfiguration newInstance() {
        return new SocketConnectorConfiguration(SocketConnectorConfiguration.factory());
    }

    public static SocketConnectorConfiguration create(Consumer<Factory> configurer) {
        Factory factory = SocketConnectorConfiguration.factory();
        configurer.accept(factory);
        return factory.build();
    }

    public boolean enableTcpKeepAlive() {
        return this.enableTcpKeepAlive;
    }

    public boolean enableTcpFastOpen() {
        return this.enableTcpFastOpen;
    }

    public int tcpFastOpenMaxPendingConnections() {
        return this.tcpFastOpenMaxPendingConnections;
    }

    public static final class Factory
    extends AbstractExternalConnectorConfiguration.AbstractFactory<Factory> {
        private boolean enableTcpKeepAlive = true;
        private boolean enableTcpFastOpen = false;
        private int tcpFastOpenMaxPendingConnections = 128;

        private Factory() {
        }

        @Override
        public SocketConnectorConfiguration build() {
            return new SocketConnectorConfiguration(this);
        }

        @Override
        public Factory fromConfig(Config config) {
            super.fromConfig(config);
            this.enableTcpKeepAlive = (Boolean)config.get(BoltConnectorInternalSettings.tcp_keep_alive);
            this.enableTcpFastOpen = (Boolean)config.get(BoltConnectorInternalSettings.tcp_fast_open);
            this.tcpFastOpenMaxPendingConnections = (Integer)config.get(BoltConnectorInternalSettings.tcp_fast_open_max_pending_connections);
            return this;
        }

        public Factory enableTcpKeepAlive(boolean value) {
            this.enableTcpKeepAlive = value;
            return this;
        }

        public Factory enableTcpFastOpen(boolean value) {
            this.enableTcpFastOpen = value;
            return this;
        }

        public Factory tcpFastOpenMaxPendingConnections(int value) {
            Preconditions.requirePositive((int)value);
            this.tcpFastOpenMaxPendingConnections = value;
            return this;
        }
    }
}

