/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.unix.DomainSocketAddress;
import java.io.IOException;
import java.net.BindException;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Clock;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.connection.BoltDriverMetricsMonitor;
import org.neo4j.bolt.protocol.common.connection.hint.ConnectionHintRegistry;
import org.neo4j.bolt.protocol.common.connector.accounting.error.ErrorAccountant;
import org.neo4j.bolt.protocol.common.connector.accounting.traffic.NoopTrafficAccountant;
import org.neo4j.bolt.protocol.common.connector.config.DomainSocketConnectorConfiguration;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.netty.AbstractNettyConnector;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.configuration.helpers.PortBindException;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.util.Preconditions;

public class DomainSocketNettyConnector
extends AbstractNettyConnector<DomainSocketConnectorConfiguration> {
    private final Path path;

    public DomainSocketNettyConnector(String id, Path path, MemoryPool memoryPool, Clock clock, ByteBufAllocator allocator, EventLoopGroup bossGroup, EventLoopGroup workerGroup, ConnectorTransport transport, Connection.Factory connectionFactory, NetworkConnectionTracker connectionTracker, BoltProtocolRegistry protocolRegistry, Authentication authentication, AuthConfigProvider authConfigProvider, DefaultDatabaseResolver defaultDatabaseResolver, ConnectionHintRegistry connectionHintRegistry, TransactionManager transactionManager, RoutingService routingService, ErrorAccountant errorAccountant, BoltDriverMetricsMonitor driverMetricsMonitor, DomainSocketConnectorConfiguration configuration, InternalLogProvider userLogProvider, InternalLogProvider logging) {
        super(id, (SocketAddress)new DomainSocketAddress(path.toFile()), memoryPool, clock, allocator, bossGroup, workerGroup, transport, connectionFactory, connectionTracker, protocolRegistry, authentication, authConfigProvider, defaultDatabaseResolver, connectionHintRegistry, transactionManager, routingService, errorAccountant, NoopTrafficAccountant.getInstance(), driverMetricsMonitor, configuration, userLogProvider, logging);
        Preconditions.checkArgument((transport.serverDomainSocketChannelType() != null ? 1 : 0) != 0, (String)("Unsupported transport: " + transport.getName() + " does not support domain sockets"));
        this.path = path;
    }

    @Override
    protected Class<? extends ServerChannel> channelType() {
        return this.transport.serverDomainSocketChannelType();
    }

    @Override
    protected void onStart() throws Exception {
        super.onStart();
        if (Files.exists(this.path, new LinkOption[0])) {
            if (!((DomainSocketConnectorConfiguration)this.configuration()).deleteSocketFile()) {
                throw new PortBindException(this.bindAddress, (Throwable)new BindException("Loopback listen file: " + String.valueOf(this.path) + " already exists."));
            }
            try {
                Files.deleteIfExists(this.path);
            }
            catch (IOException ex) {
                throw new PortBindException(this.bindAddress, (Throwable)ex);
            }
        }
    }

    @Override
    protected void logStartupMessage() {
        this.userLog.info("Bolt (loopback) enabled on file %s", new Object[]{this.path});
    }
}

