/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.netty;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Clock;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.connection.BoltDriverMetricsMonitor;
import org.neo4j.bolt.protocol.common.connection.hint.ConnectionHintRegistry;
import org.neo4j.bolt.protocol.common.connector.accounting.error.ErrorAccountant;
import org.neo4j.bolt.protocol.common.connector.accounting.traffic.TrafficAccountant;
import org.neo4j.bolt.protocol.common.connector.config.SocketConnectorConfiguration;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.netty.AbstractNettyConnector;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorOption;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.server.config.AuthConfigProvider;

public class SocketNettyConnector
extends AbstractNettyConnector<SocketConnectorConfiguration> {
    private final ConnectorType connectorType;
    private final ConnectorPortRegister portRegister;

    public SocketNettyConnector(String id, SocketAddress bindAddress, ConnectorType connectorType, ConnectorPortRegister portRegister, MemoryPool memoryPool, Clock clock, ByteBufAllocator allocator, EventLoopGroup bossGroup, EventLoopGroup workerGroup, ConnectorTransport transport, Connection.Factory connectionFactory, NetworkConnectionTracker connectionTracker, BoltProtocolRegistry protocolRegistry, Authentication authentication, AuthConfigProvider authConfigProvider, DefaultDatabaseResolver defaultDatabaseResolver, ConnectionHintRegistry connectionHintRegistry, TransactionManager transactionManager, RoutingService routingService, ErrorAccountant errorAccountant, TrafficAccountant trafficAccountant, BoltDriverMetricsMonitor driverMetricsMonitor, SocketConnectorConfiguration configuration, InternalLogProvider userLogProvider, InternalLogProvider logging) {
        super(id, bindAddress, memoryPool, clock, allocator, bossGroup, workerGroup, transport, connectionFactory, connectionTracker, protocolRegistry, authentication, authConfigProvider, defaultDatabaseResolver, connectionHintRegistry, transactionManager, routingService, errorAccountant, trafficAccountant, driverMetricsMonitor, configuration, userLogProvider, logging);
        this.connectorType = connectorType;
        this.portRegister = portRegister;
    }

    @Override
    protected Class<? extends ServerChannel> channelType() {
        return this.transport.serverSocketChannelType();
    }

    @Override
    protected void configureServer(ServerBootstrap bootstrap) {
        super.configureServer(bootstrap);
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)((SocketConnectorConfiguration)this.configuration()).enableTcpKeepAlive());
        if (((SocketConnectorConfiguration)this.configuration()).enableTcpFastOpen()) {
            if (this.transport.supportsOption(ConnectorOption.TCP_FAST_OPEN)) {
                ConnectorOption.TCP_FAST_OPEN.set((AbstractBootstrap<?, ?>)bootstrap, ((SocketConnectorConfiguration)this.configuration()).tcpFastOpenMaxPendingConnections());
            } else {
                this.userLog.warn("TCP fast-open has been requested but is not currently supported on this platform");
            }
        }
    }

    @Override
    protected void onChannelBound(Channel channel) {
        this.registerChannel();
    }

    protected void registerChannel() {
        this.portRegister.register(this.connectorType, (InetSocketAddress)this.address());
    }

    @Override
    protected void onChannelClose(Channel channel) {
        this.deregisterChannel();
    }

    protected void deregisterChannel() {
        this.portRegister.deregister(this.connectorType);
    }

    @Override
    protected void logStartupMessage() {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.bindAddress;
        String connectorName = this.connectorType == ConnectorType.BOLT ? "Bolt" : (this.connectorType == ConnectorType.INTRA_BOLT ? "Bolt (Routing)" : this.connectorType.name());
        this.userLog.info(connectorName + " enabled on %s.", new Object[]{org.neo4j.configuration.helpers.SocketAddress.format((String)inetSocketAddress.getHostName(), (int)inetSocketAddress.getPort())});
    }
}

