/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.transport;

import io.netty.channel.IoHandlerFactory;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueIoHandler;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.channel.unix.ServerDomainSocketChannel;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorOption;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;

public final class KqueueConnectorTransport
implements ConnectorTransport {
    @Override
    public String getName() {
        return "KQueue";
    }

    @Override
    public boolean isAvailable() {
        return KQueue.isAvailable();
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public boolean supportsOption(ConnectorOption<?> option) {
        return option == ConnectorOption.TCP_FAST_OPEN || option == ConnectorOption.TCP_FAST_OPEN_CONNECT;
    }

    @Override
    public IoHandlerFactory createIoHandlerFactory() {
        return KQueueIoHandler.newFactory();
    }

    public Class<? extends SocketChannel> socketChannelType() {
        return KQueueSocketChannel.class;
    }

    public Class<? extends ServerSocketChannel> serverSocketChannelType() {
        return KQueueServerSocketChannel.class;
    }

    @Override
    public Class<? extends DomainSocketChannel> domainSocketChannelType() {
        return KQueueDomainSocketChannel.class;
    }

    @Override
    public Class<? extends ServerDomainSocketChannel> serverDomainSocketChannelType() {
        return KQueueServerDomainSocketChannel.class;
    }
}

