/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.neo4j.bolt.fsm.error.BoltException;
import org.neo4j.bolt.fsm.error.ConnectionTerminating;
import org.neo4j.bolt.protocol.common.message.response.FailureMessage;
import org.neo4j.bolt.protocol.common.message.response.FailureMetadata;
import org.neo4j.gqlstatus.DiagnosticRecord;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.kernel.api.exceptions.HasQuery;
import org.neo4j.kernel.api.exceptions.Status;

public class Error {
    private static final Map<String, Object> DEFAULT_DIAGNOSTIC_RECORD = DiagnosticRecord.from().build().asMap();
    private final Status status;
    private final String message;
    private final Throwable cause;
    private final Throwable wrappedThrowable;
    private final UUID reference;
    private final boolean fatal;
    private final Long queryId;

    private Error(Status status, String message, Throwable cause, boolean fatal, Long queryId, Throwable wrappedThrowable) {
        this.status = status;
        this.message = message;
        this.cause = cause;
        this.fatal = fatal;
        this.reference = UUID.randomUUID();
        this.queryId = queryId;
        this.wrappedThrowable = wrappedThrowable;
    }

    private Error(Status status, String message, boolean fatal) {
        this(status, message, null, fatal, null, null);
    }

    public Status status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Throwable cause() {
        return this.cause;
    }

    public UUID reference() {
        return this.reference;
    }

    public Long queryId() {
        return this.queryId;
    }

    public Throwable wrappedThrowable() {
        return this.wrappedThrowable;
    }

    public FailureMessage asBoltMessage() {
        Throwable throwable = this.wrappedThrowable;
        if (throwable instanceof ErrorGqlStatusObject) {
            ErrorGqlStatusObject wrapped = (ErrorGqlStatusObject)throwable;
            return new FailureMessage(new FailureMetadata(this.status(), this.message(), wrapped.statusDescription(), wrapped.gqlStatus(), wrapped.diagnosticRecord(), wrapped.cause().map(Error::causeAsFailureMetadata).orElse(null)), this.isFatal());
        }
        return new FailureMessage(new FailureMetadata(this.status(), this.message(), ErrorGqlStatusObject.DEFAULT_STATUS_DESCRIPTION, ErrorGqlStatusObject.DEFAULT_STATUS_CODE, DEFAULT_DIAGNOSTIC_RECORD, null), this.isFatal());
    }

    private static FailureMetadata causeAsFailureMetadata(ErrorGqlStatusObject error) {
        Status.General status = Status.General.UnknownError;
        if (error instanceof Status.HasStatus) {
            Status.HasStatus errorWithStatus = (Status.HasStatus)error;
            status = errorWithStatus.status();
        }
        return new FailureMetadata((Status)status, error.getMessage(), error.statusDescription(), error.gqlStatus(), error.diagnosticRecord(), error.cause().map(Error::causeAsFailureMetadata).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.status, error.status) && Objects.equals(this.message, error.message) && Objects.equals(this.cause, error.cause) && Objects.equals(this.wrappedThrowable, error.wrappedThrowable);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.message, this.cause, this.wrappedThrowable);
    }

    public String toString() {
        return "Neo4jError{status=" + String.valueOf(this.status) + ", message='" + this.message + "', cause=" + String.valueOf(this.cause) + ", wrappedThrowable=" + String.valueOf(this.wrappedThrowable) + "}";
    }

    @Deprecated
    public static Error from(Status status, String message) {
        return new Error(status, message, false);
    }

    public static Error from(Throwable any) {
        return Error.from(any, false);
    }

    public static Error from(Throwable any, boolean fatal) {
        for (Throwable cause = any; cause != null; cause = cause.getCause()) {
            Long queryId = null;
            if (cause instanceof ConnectionTerminating) {
                fatal = true;
            }
            if (cause instanceof HasQuery) {
                queryId = ((HasQuery)cause).query();
            }
            if (cause instanceof DatabaseShutdownException) {
                return new Error((Status)Status.General.DatabaseUnavailable, Status.General.DatabaseUnavailable.code().description(), any, fatal, queryId, cause);
            }
            if (cause instanceof Status.HasStatus) {
                return new Error(((Status.HasStatus)cause).status(), cause.getMessage(), any, fatal, queryId, cause);
            }
            if (cause instanceof OutOfMemoryError) {
                return new Error((Status)Status.General.OutOfMemoryError, cause.getMessage(), any, fatal, queryId, (Throwable)((Object)BoltException.outOfMemory(any)));
            }
            if (!(cause instanceof StackOverflowError)) continue;
            return new Error((Status)Status.General.StackOverFlowError, cause.getMessage(), any, fatal, queryId, (Throwable)((Object)BoltException.stackOverflow(any)));
        }
        return new Error((Status)Status.General.UnknownError, any != null ? any.getMessage() : null, any, fatal, null, (Throwable)((Object)BoltException.unknownError(any)));
    }

    public static Error fatalFrom(Throwable any) {
        return Error.from(any, true);
    }

    public boolean isFatal() {
        return this.fatal;
    }
}

