/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.state;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class HandlerRegistry<I, H>
implements Iterable<H> {
    private final Map<Class<? extends I>, H> handlerMap;
    private final Map<Class<? extends I>, H> handlerCache = new ConcurrentHashMap<Class<? extends I>, H>();

    private HandlerRegistry(Map<Class<? extends I>, H> handlerMap) {
        this.handlerMap = new HashMap<Class<I>, H>(handlerMap);
    }

    public static <I, H> Factory<I, H> builder() {
        return new Factory();
    }

    public H find(Class<? extends I> type) {
        H cached = this.handlerCache.get(type);
        if (cached != null) {
            return cached;
        }
        H exactCandidates = this.handlerMap.get(type);
        if (exactCandidates != null) {
            this.handlerCache.put(type, exactCandidates);
            return exactCandidates;
        }
        Class candidateKey = this.handlerMap.keySet().stream().filter(candidate -> candidate.isAssignableFrom(type)).min((a, b) -> {
            if (a.isAssignableFrom((Class<?>)b)) {
                return 1;
            }
            if (b.isAssignableFrom((Class<?>)a)) {
                return -1;
            }
            return 0;
        }).orElse(null);
        if (candidateKey == null) {
            return null;
        }
        H candidate2 = this.handlerMap.get(candidateKey);
        this.handlerCache.put(candidateKey, candidate2);
        return candidate2;
    }

    @Override
    public Iterator<H> iterator() {
        return this.handlerMap.values().iterator();
    }

    static final class Factory<I, H> {
        private final Map<Class<? extends I>, H> handlerMap = new HashMap<Class<? extends I>, H>();

        private Factory() {
        }

        public HandlerRegistry<I, H> build() {
            return new HandlerRegistry<I, H>(this.handlerMap);
        }

        public void register(Class<? extends I> type, H handler) {
            this.handlerMap.put(type, handler);
        }
    }
}

