/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.config;

import java.net.SocketAddress;
import java.util.Objects;
import org.neo4j.bolt.protocol.common.connector.config.AbstractNettyConnectorConfiguration;
import org.neo4j.bolt.protocol.common.connector.config.ExternalConnectorConfiguration;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnector;

public abstract class AbstractExternalConnectorConfiguration
extends AbstractNettyConnectorConfiguration
implements ExternalConnectorConfiguration {
    private final SocketAddress advertisedAddress;
    private final boolean requiresEncryption;

    public AbstractExternalConnectorConfiguration(AbstractFactory<?> builder) {
        super((AbstractNettyConnectorConfiguration.AbstractFactory<?>)builder);
        Objects.requireNonNull(builder.advertisedAddress, "Advertised address cannot be null");
        this.advertisedAddress = builder.advertisedAddress;
        this.requiresEncryption = builder.requiresEncryption;
    }

    @Override
    public SocketAddress advertisedAddress() {
        return this.advertisedAddress;
    }

    @Override
    public boolean requireEncryption() {
        return this.requiresEncryption;
    }

    public static abstract class AbstractFactory<SELF extends AbstractFactory<SELF>>
    extends AbstractNettyConnectorConfiguration.AbstractFactory<SELF>
    implements ExternalConnectorConfiguration.Factory<SELF> {
        private SocketAddress advertisedAddress;
        private boolean requiresEncryption;

        @Override
        public abstract AbstractExternalConnectorConfiguration build();

        @Override
        public SELF fromConfig(Config config) {
            super.fromConfig(config);
            this.advertisedAddress = ((org.neo4j.configuration.helpers.SocketAddress)config.get(BoltConnector.advertised_address)).socketAddress();
            return (SELF)this;
        }

        @Override
        public SELF advertisedAddress(SocketAddress value) {
            this.advertisedAddress = value;
            return (SELF)this;
        }

        @Override
        public SELF requireEncryption(boolean value) {
            this.requiresEncryption = value;
            return (SELF)this;
        }
    }
}

