/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.connection;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.bolt.protocol.io.pipeline.WriterPipeline;
import org.neo4j.bolt.protocol.io.reader.DateTimeReader;
import org.neo4j.bolt.protocol.io.reader.DateTimeZoneIdReader;
import org.neo4j.bolt.protocol.io.writer.UtcStructWriter;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.values.storable.Value;

public enum Feature {
    UTC_DATETIME("utc"){

        @Override
        public StructRegistry<Connection, Value> decorateStructRegistry(StructRegistry<Connection, Value> delegate) {
            return delegate.builderOf().unregisterReader(StructType.DATE_TIME_LEGACY.getTag()).unregisterReader(StructType.DATE_TIME_ZONE_ID_LEGACY.getTag()).register(DateTimeReader.getInstance()).register(DateTimeZoneIdReader.getInstance()).build();
        }

        @Override
        public void configureWriterPipeline(WriterPipeline pipeline) {
            pipeline.addFirst(UtcStructWriter.getInstance());
        }
    };

    private static final Map<String, Feature> idToFeatureMap;
    private final String id;

    private Feature(String id) {
        this.id = id;
    }

    public static Feature findFeatureById(String id) {
        return idToFeatureMap.get(id);
    }

    public String getId() {
        return this.id;
    }

    public StructRegistry<Connection, Value> decorateStructRegistry(StructRegistry<Connection, Value> delegate) {
        return delegate;
    }

    public void configureWriterPipeline(WriterPipeline pipeline) {
    }

    static {
        idToFeatureMap = new HashMap<String, Feature>();
        for (Feature feature : Feature.values()) {
            idToFeatureMap.put(feature.id, feature);
        }
    }
}

