/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.pcap.PcapWriteHandler;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.neo4j.bolt.protocol.common.connector.config.NettyConnectorConfiguration;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.netty.AbstractNettyConnector;
import org.neo4j.bolt.protocol.common.handler.TrafficAccountantHandler;
import org.neo4j.bolt.protocol.common.handler.TransportSelectionHandler;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;

public class BoltChannelInitializer
extends ChannelInitializer<Channel> {
    private static final long SHALLOW_SIZE_PACKET_CAPTURE = HeapEstimator.shallowSizeOfInstance(PcapWriteHandler.class);
    private final AbstractNettyConnector<?> connector;
    private final ByteBufAllocator allocator;
    private final InternalLogProvider logging;
    private final InternalLog log;

    public BoltChannelInitializer(AbstractNettyConnector<?> connector, ByteBufAllocator allocator, SslContext sslContext, InternalLogProvider logging) {
        this.allocator = allocator;
        this.connector = connector;
        this.logging = logging;
        this.log = logging.getLog(BoltChannelInitializer.class);
    }

    public BoltChannelInitializer(AbstractNettyConnector<?> connector, ByteBufAllocator allocator, InternalLogProvider logging) {
        this(connector, allocator, null, logging);
    }

    protected void initChannel(Channel ch) {
        this.log.debug("Incoming connection from %s", new Object[]{ch.remoteAddress()});
        Connection connection = this.connector.createConnection(ch);
        connection.memoryTracker().allocateHeap(HeapEstimator.sizeOf((Object)ch) + TransportSelectionHandler.SHALLOW_SIZE + TrafficAccountantHandler.SHALLOW_SIZE);
        ch.pipeline().addLast(new ChannelHandler[]{new TrafficAccountantHandler(this.connector.trafficAccountant())});
        if (((NettyConnectorConfiguration)this.connector.configuration()).enableProtocolCapture()) {
            connection.memoryTracker().allocateHeap(SHALLOW_SIZE_PACKET_CAPTURE);
            Path file = ((NettyConnectorConfiguration)this.connector.configuration()).protocolCapturePath().resolve(connection.id() + ".pcap").toAbsolutePath();
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                ch.pipeline().addLast("captureHandler", (ChannelHandler)PcapWriteHandler.builder().build(Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING)));
                this.log.info("[%s] Created packet capture for connection %s at %s", new Object[]{ch.remoteAddress(), connection.id(), file});
            }
            catch (IOException ex) {
                this.log.warn("[" + String.valueOf(ch.remoteAddress()) + "] Failed to initialize Bolt capture handler for connection", (Throwable)ex);
            }
        }
        ch.pipeline().addLast(new ChannelHandler[]{new TransportSelectionHandler(this.logging)});
        connection.notifyListeners(listener -> listener.onNetworkPipelineInitialized(ch.pipeline()));
    }
}

