/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.decoder.generic;

import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.decoder.MessageDecoder;
import org.neo4j.bolt.protocol.common.message.request.generic.TelemetryMessage;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.util.PackstreamConditions;
import org.neo4j.values.storable.LongValue;

public class TelemetryMessageDecoder
implements MessageDecoder<TelemetryMessage> {
    private static final TelemetryMessageDecoder INSTANCE = new TelemetryMessageDecoder();
    private static final String apiKey = "api";

    public static TelemetryMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 84;
    }

    @Override
    public TelemetryMessage read(Connection connection, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        PackstreamConditions.requireLength(header, 1);
        PackstreamValueReader<Connection> valueReader = connection.valueReader(buffer);
        LongValue apiType = valueReader.readLong();
        if (apiType != null) {
            TelemetryMessage.DriverInterfaceType driverInterfaceTypeUsage = TelemetryMessage.DriverInterfaceType.fromLong(apiType.value());
            return new TelemetryMessage(driverInterfaceTypeUsage);
        }
        throw IllegalStructArgumentException.expectedIntegerButGotNull(apiKey);
    }
}

