/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.decoder.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.protocol.common.message.notifications.DefaultNotificationsConfig;
import org.neo4j.bolt.protocol.common.message.notifications.DisabledNotificationsConfig;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.notifications.SelectiveNotificationsConfig;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public final class NotificationsConfigMetadataReader {
    private static final String MINIMUM_SEVERITY_KEY = "notifications_minimum_severity";
    private static final String DISABLED_CATEGORIES_KEY = "notifications_disabled_categories";
    private static final String DISABLED_CLASSIFICATION_KEY = "notifications_disabled_classifications";
    private static final String DISABLE_ALL_NOTIFICATIONS = "OFF";

    private NotificationsConfigMetadataReader() {
    }

    public static NotificationsConfig readFromMapValue(MapValue meta) throws IllegalStructArgumentException {
        return NotificationsConfigMetadataReader.readFromMapValue(meta, DISABLED_CLASSIFICATION_KEY);
    }

    public static NotificationsConfig readLegacyFromMapValue(MapValue meta) throws IllegalStructArgumentException {
        return NotificationsConfigMetadataReader.readFromMapValue(meta, DISABLED_CATEGORIES_KEY);
    }

    private static NotificationsConfig readFromMapValue(MapValue meta, String disabledClassificationKey) throws IllegalStructArgumentException {
        Object object;
        String minimumSeverity = null;
        ArrayList<String> categoriesToIgnore = null;
        if (meta.containsKey(MINIMUM_SEVERITY_KEY)) {
            object = meta.get(MINIMUM_SEVERITY_KEY);
            if (object instanceof StringValue) {
                StringValue stringValue = (StringValue)object;
                minimumSeverity = stringValue.stringValue();
            } else {
                throw IllegalStructArgumentException.wrongTypeForFieldName(MINIMUM_SEVERITY_KEY, String.valueOf(meta.get(MINIMUM_SEVERITY_KEY)), List.of("String"), meta.get(MINIMUM_SEVERITY_KEY).getTypeName(), "Required to be a String");
            }
        }
        if (meta.containsKey(disabledClassificationKey)) {
            object = meta.get(disabledClassificationKey);
            if (object instanceof ListValue) {
                ListValue listValue = (ListValue)object;
                categoriesToIgnore = new ArrayList<String>();
                for (AnyValue x : listValue) {
                    if (x instanceof StringValue) {
                        StringValue stringValue = (StringValue)x;
                        categoriesToIgnore.add(stringValue.stringValue());
                        continue;
                    }
                    throw IllegalStructArgumentException.wrongTypeForFieldName(disabledClassificationKey, String.valueOf(meta.get(disabledClassificationKey)), List.of("LIST<STRING>"), meta.get(disabledClassificationKey).getTypeName(), "Required to be a List::String");
                }
            } else {
                throw IllegalStructArgumentException.wrongTypeForFieldName(disabledClassificationKey, String.valueOf(meta.get(disabledClassificationKey)), List.of("LIST<STRING>"), meta.get(disabledClassificationKey).getTypeName(), "Required to be a List::String");
            }
        }
        return NotificationsConfigMetadataReader.getNotificationsConfig(minimumSeverity, categoriesToIgnore);
    }

    public static NotificationsConfig readFromMap(Map<String, Object> meta) throws IllegalStructArgumentException {
        return NotificationsConfigMetadataReader.readFromMap(meta, DISABLED_CLASSIFICATION_KEY);
    }

    public static NotificationsConfig readLegacyFromMap(Map<String, Object> meta) throws IllegalStructArgumentException {
        return NotificationsConfigMetadataReader.readFromMap(meta, DISABLED_CATEGORIES_KEY);
    }

    private static NotificationsConfig readFromMap(Map<String, Object> meta, String disabledClassificationKey) throws IllegalStructArgumentException {
        Object object;
        String minimumSeverity = null;
        ArrayList<String> categoriesToIgnore = null;
        if (meta.containsKey(MINIMUM_SEVERITY_KEY)) {
            object = meta.get(MINIMUM_SEVERITY_KEY);
            if (object instanceof String) {
                String stringValue;
                minimumSeverity = stringValue = (String)object;
            } else {
                throw IllegalStructArgumentException.wrongTypeForFieldName(MINIMUM_SEVERITY_KEY, String.valueOf(meta.get(MINIMUM_SEVERITY_KEY)), List.of("String"), meta.get(MINIMUM_SEVERITY_KEY).getClass().getSimpleName(), "Required to be a String");
            }
        }
        if (meta.containsKey(disabledClassificationKey)) {
            object = meta.get(disabledClassificationKey);
            if (object instanceof List) {
                List listValue = (List)object;
                categoriesToIgnore = new ArrayList<String>();
                for (Object x : listValue) {
                    if (x instanceof String) {
                        String stringValue = (String)x;
                        categoriesToIgnore.add(stringValue);
                        continue;
                    }
                    throw IllegalStructArgumentException.wrongTypeForFieldName(disabledClassificationKey, String.valueOf(meta.get(disabledClassificationKey)), List.of("LIST<STRING>"), meta.get(disabledClassificationKey).getClass().getSimpleName(), "Required to be a List::String");
                }
            } else {
                throw IllegalStructArgumentException.wrongTypeForFieldName(disabledClassificationKey, String.valueOf(meta.get(disabledClassificationKey)), List.of("LIST<STRING>"), meta.get(disabledClassificationKey).getClass().getSimpleName(), "Required to be a List::String");
            }
        }
        return NotificationsConfigMetadataReader.getNotificationsConfig(minimumSeverity, categoriesToIgnore);
    }

    private static NotificationsConfig getNotificationsConfig(String minimumSeverity, ArrayList<String> categoriesToIgnore) throws IllegalStructArgumentException {
        if (minimumSeverity == null && categoriesToIgnore == null) {
            return DefaultNotificationsConfig.getInstance();
        }
        if (minimumSeverity != null && minimumSeverity.equalsIgnoreCase(DISABLE_ALL_NOTIFICATIONS)) {
            return DisabledNotificationsConfig.getInstance();
        }
        return new SelectiveNotificationsConfig(minimumSeverity, categoriesToIgnore);
    }
}

