/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.request.generic;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.packstream.error.reader.PackstreamReaderException;

public record TelemetryMessage(DriverInterfaceType interfaceType) implements RequestMessage
{
    public static final short SIGNATURE = 84;

    @Override
    public String toString() {
        return "TelemetryMessage{interfaceType=" + String.valueOf((Object)this.interfaceType) + "}";
    }

    public static enum DriverInterfaceType {
        TRANSACTION_FUNCTION(0L),
        UNMANAGED_TRANSACTION(1L),
        MANAGED_TRANSACTION(2L),
        EXECUTE_QUERY(3L);

        private final long marker;
        private static final Map<Long, DriverInterfaceType> DRIVER_INTERFACE_MAP;

        private DriverInterfaceType(long marker) {
            this.marker = marker;
        }

        public static DriverInterfaceType fromLong(long type) throws PackstreamReaderException {
            DriverInterfaceType interfaceType = DRIVER_INTERFACE_MAP.get(type);
            if (interfaceType == null) {
                throw PackstreamReaderException.unknownDriverInterfaceType(type, DRIVER_INTERFACE_MAP.keySet());
            }
            return interfaceType;
        }

        static {
            HashMap<Long, DriverInterfaceType> map = new HashMap<Long, DriverInterfaceType>();
            for (DriverInterfaceType type : DriverInterfaceType.values()) {
                map.put(type.marker, type);
            }
            DRIVER_INTERFACE_MAP = Collections.unmodifiableMap(map);
        }
    }
}

