/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io;

import org.neo4j.bolt.protocol.io.pipeline.WriterContext;
import org.neo4j.packstream.struct.StructHeader;

public enum StructType {
    NODE('N', 4, 3),
    RELATIONSHIP('R', 8, 5),
    UNBOUND_RELATIONSHIP('r', 4, 3),
    PATH('P', 3),
    DATE('D', 1),
    TIME('T', 2),
    LOCAL_TIME('t', 1),
    DATE_TIME('I', 3),
    DATE_TIME_ZONE_ID('i', 3),
    DATE_TIME_LEGACY('F', 3),
    DATE_TIME_ZONE_ID_LEGACY('f', 3),
    LOCAL_DATE_TIME('d', 2),
    DURATION('E', 4),
    POINT_2D('X', 3),
    POINT_3D('Y', 4),
    VECTOR('V', 2);

    private final short tag;
    private final short defaultSize;
    @Deprecated(since="5.0", forRemoval=true)
    private final short legacySize;

    private StructType(@Deprecated(since="5.0", forRemoval=true) char tag, int defaultSize, int legacySize) {
        this.tag = (short)tag;
        this.defaultSize = (short)defaultSize;
        this.legacySize = (short)legacySize;
    }

    private StructType(char tag, int defaultSize) {
        this(tag, defaultSize, defaultSize);
    }

    public short getTag() {
        return this.tag;
    }

    public short getDefaultSize() {
        return this.defaultSize;
    }

    @Deprecated(since="5.0", forRemoval=true)
    public short getLegacySize() {
        return this.legacySize;
    }

    private void writeHeader(WriterContext ctx, long length) {
        ctx.buffer().writeStructHeader(new StructHeader(length, this.getTag()));
    }

    public void writeHeader(WriterContext ctx) {
        this.writeHeader(ctx, this.getDefaultSize());
    }

    @Deprecated(since="5.0", forRemoval=true)
    public void writeLegacyHeader(WriterContext ctx) {
        this.writeHeader(ctx, this.getLegacySize());
    }
}

