/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v57;

import org.neo4j.bolt.fsm.StateMachineConfiguration;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.AbstractBoltProtocol;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.MetadataHandler;
import org.neo4j.bolt.protocol.common.fsm.transition.authentication.AuthenticationStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.authentication.LogoffStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.ready.CreateAutocommitStatementStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.ready.CreateTransactionStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.ready.RouteStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.ready.TelemetryStateTransition;
import org.neo4j.bolt.protocol.io.pipeline.WriterPipeline;
import org.neo4j.bolt.protocol.io.reader.DateReader;
import org.neo4j.bolt.protocol.io.reader.DateTimeReader;
import org.neo4j.bolt.protocol.io.reader.DateTimeZoneIdReader;
import org.neo4j.bolt.protocol.io.reader.DurationReader;
import org.neo4j.bolt.protocol.io.reader.LocalDateTimeReader;
import org.neo4j.bolt.protocol.io.reader.LocalTimeReader;
import org.neo4j.bolt.protocol.io.reader.Point2dReader;
import org.neo4j.bolt.protocol.io.reader.Point3dReader;
import org.neo4j.bolt.protocol.io.reader.TimeReader;
import org.neo4j.bolt.protocol.io.writer.VectorBarrierStructWriter;
import org.neo4j.bolt.protocol.v56.metadata.MetadataHandlerV56;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.values.storable.Value;

public final class BoltProtocolV57
extends AbstractBoltProtocol {
    public static final ProtocolVersion VERSION = new ProtocolVersion(5, 7);
    private static final BoltProtocolV57 INSTANCE = new BoltProtocolV57();

    private BoltProtocolV57() {
    }

    public static BoltProtocolV57 getInstance() {
        return INSTANCE;
    }

    @Override
    public ProtocolVersion version() {
        return VERSION;
    }

    @Override
    protected StateMachineConfiguration.Factory createStateMachine() {
        return super.createStateMachine().withState(States.AUTHENTICATION, AuthenticationStateTransition.getInstance()).withState(States.READY, CreateTransactionStateTransition.getInstance(), RouteStateTransition.getInstance(), CreateAutocommitStatementStateTransition.getInstance(), LogoffStateTransition.getInstance(), TelemetryStateTransition.getInstance());
    }

    @Override
    public void registerStructReaders(StructRegistry.Builder<Connection, Value> builder) {
        builder.register(DateReader.getInstance()).register(DurationReader.getInstance()).register(LocalDateTimeReader.getInstance()).register(LocalTimeReader.getInstance()).register(Point2dReader.getInstance()).register(Point3dReader.getInstance()).register(TimeReader.getInstance()).register(DateTimeReader.getInstance()).register(DateTimeZoneIdReader.getInstance());
    }

    @Override
    public void registerStructWriters(WriterPipeline pipeline) {
        pipeline.addLast(VectorBarrierStructWriter.getInstance());
        super.registerStructWriters(pipeline);
    }

    @Override
    public MetadataHandler metadataHandler() {
        return MetadataHandlerV56.getInstance();
    }
}

