/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.util;

import java.util.List;
import java.util.OptionalLong;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.util.PackstreamConditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public final class PackstreamConversions {
    private PackstreamConversions() {
    }

    public static ListValue asNullableListValue(String fieldName, AnyValue fieldValue) throws IllegalStructArgumentException {
        if (fieldValue == Values.NO_VALUE) {
            return null;
        }
        if (fieldValue instanceof ListValue) {
            ListValue listValue = (ListValue)fieldValue;
            return listValue;
        }
        throw IllegalStructArgumentException.wrongTypeForFieldName(fieldName, String.valueOf(fieldValue), List.of("list"), fieldValue.getTypeName(), "Expected list");
    }

    public static long asLong(String fieldName, Object fieldValue) throws IllegalStructArgumentException {
        PackstreamConditions.requireNonNull(fieldName, fieldValue);
        return PackstreamConversions.asNullableLong(fieldName, fieldValue);
    }

    public static Long asNullableLong(String fieldName, Object fieldValue) throws IllegalStructArgumentException {
        if (fieldValue instanceof Long) {
            Long longValue = (Long)fieldValue;
            return longValue;
        }
        if (fieldValue == null) {
            return null;
        }
        throw IllegalStructArgumentException.wrongTypeForFieldName(fieldName, String.valueOf(fieldValue), List.of("LONG"), fieldValue.getClass().getSimpleName(), "Expected long");
    }

    public static long asLongValue(String fieldName, AnyValue fieldValue) throws IllegalStructArgumentException {
        if (fieldValue == Values.NO_VALUE) {
            throw IllegalStructArgumentException.expectedNonNullValue(fieldName);
        }
        return PackstreamConversions.asNullableLongValue(fieldName, fieldValue).orElseThrow(() -> IllegalStructArgumentException.wrongTypeForFieldName(fieldName, String.valueOf(fieldValue), List.of("LONG"), fieldValue.getTypeName(), "Expected long"));
    }

    public static OptionalLong asNullableLongValue(String fieldName, AnyValue fieldValue) throws IllegalStructArgumentException {
        if (fieldValue instanceof LongValue) {
            LongValue longValue = (LongValue)fieldValue;
            return OptionalLong.of(longValue.longValue());
        }
        if (fieldValue == Values.NO_VALUE) {
            return OptionalLong.empty();
        }
        throw IllegalStructArgumentException.wrongTypeForFieldName(fieldName, String.valueOf(fieldValue), List.of("LONG"), fieldValue.getTypeName(), "Expected long");
    }

    public static MapValue asNullableMapValue(String fieldName, AnyValue fieldValue) throws IllegalStructArgumentException {
        if (fieldValue instanceof MapValue) {
            MapValue mapValue = (MapValue)fieldValue;
            return mapValue;
        }
        if (fieldValue == Values.NO_VALUE) {
            return null;
        }
        throw IllegalStructArgumentException.wrongTypeForFieldName(fieldName, String.valueOf(fieldValue), List.of("MAP"), fieldValue.getTypeName(), "Expected dictionary");
    }

    public static String asString(String fieldName, Object fieldValue) throws IllegalStructArgumentException {
        PackstreamConditions.requireNonNull(fieldName, fieldValue);
        return PackstreamConversions.asNullableString(fieldName, fieldValue);
    }

    public static String asNullableString(String fieldName, Object fieldValue) throws IllegalStructArgumentException {
        if (fieldValue instanceof String) {
            String stringValue = (String)fieldValue;
            return stringValue;
        }
        if (fieldValue == null) {
            return null;
        }
        throw IllegalStructArgumentException.wrongTypeForFieldName(fieldName, String.valueOf(fieldValue), List.of("STRING"), fieldValue.getClass().getSimpleName(), "Expected string");
    }

    public static String asNullableStringValue(String fieldName, AnyValue fieldValue) throws IllegalStructArgumentException {
        if (fieldValue instanceof TextValue) {
            TextValue textValue = (TextValue)fieldValue;
            return textValue.stringValue();
        }
        if (fieldValue == Values.NO_VALUE) {
            return null;
        }
        throw IllegalStructArgumentException.wrongTypeForFieldName(fieldName, String.valueOf(fieldValue), List.of("STRING"), fieldValue.getTypeName(), "Expected string");
    }
}

