/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import java.net.SocketAddress;
import java.time.Clock;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.connection.BoltDriverMetricsMonitor;
import org.neo4j.bolt.protocol.common.connection.hint.ConnectionHintRegistry;
import org.neo4j.bolt.protocol.common.connector.AbstractConnector;
import org.neo4j.bolt.protocol.common.connector.accounting.error.ErrorAccountant;
import org.neo4j.bolt.protocol.common.connector.accounting.traffic.TrafficAccountant;
import org.neo4j.bolt.protocol.common.connector.config.NettyConnectorConfiguration;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;
import org.neo4j.bolt.protocol.common.handler.BoltChannelInitializer;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.configuration.helpers.PortBindException;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.server.config.AuthConfigProvider;

public abstract class AbstractNettyConnector<CFG extends NettyConnectorConfiguration>
extends AbstractConnector<CFG> {
    protected final SocketAddress bindAddress;
    private final ByteBufAllocator allocator;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    protected final ConnectorTransport transport;
    protected final InternalLogProvider logging;
    protected final InternalLog userLog;
    protected final InternalLog log;
    private Channel channel;

    AbstractNettyConnector(String id, SocketAddress bindAddress, MemoryPool memoryPool, Clock clock, ByteBufAllocator allocator, EventLoopGroup bossGroup, EventLoopGroup workerGroup, ConnectorTransport transport, Connection.Factory connectionFactory, NetworkConnectionTracker connectionTracker, BoltProtocolRegistry protocolRegistry, Authentication authentication, AuthConfigProvider authConfigProvider, DefaultDatabaseResolver defaultDatabaseResolver, ConnectionHintRegistry connectionHintRegistry, TransactionManager transactionManager, RoutingService routingService, ErrorAccountant errorAccountant, TrafficAccountant trafficAccountant, BoltDriverMetricsMonitor driverMetricsMonitor, CFG configuration, InternalLogProvider userLogProvider, InternalLogProvider internalLogProvider) {
        super(id, memoryPool, clock, connectionFactory, connectionTracker, protocolRegistry, authentication, authConfigProvider, defaultDatabaseResolver, connectionHintRegistry, transactionManager, routingService, errorAccountant, trafficAccountant, driverMetricsMonitor, configuration, internalLogProvider);
        this.bindAddress = bindAddress;
        this.allocator = allocator;
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
        this.transport = transport;
        this.logging = internalLogProvider;
        this.userLog = userLogProvider.getLog(this.getClass());
        this.log = internalLogProvider.getLog(this.getClass());
    }

    protected EventLoopGroup bossGroup() {
        return this.bossGroup;
    }

    protected EventLoopGroup workerGroup() {
        return this.workerGroup;
    }

    protected Class<? extends ServerChannel> channelType() {
        return this.transport.serverSocketChannelType();
    }

    protected void configureServer(ServerBootstrap bootstrap) {
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE);
    }

    protected void onChannelBound(Channel channel) throws Exception {
    }

    protected void onChannelClose(Channel channel) {
    }

    protected ChannelInitializer<Channel> channelInitializer() {
        return new BoltChannelInitializer(this, this.allocator, this.logging);
    }

    @Override
    public SocketAddress address() {
        Channel channel = this.channel;
        if (channel == null) {
            return null;
        }
        return channel.localAddress();
    }

    @Override
    public void start() throws Exception {
        if (this.channel != null) {
            throw new IllegalStateException("Connector " + this.id() + " is already running");
        }
        this.onStart();
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(this.channelType())).group(this.bossGroup(), this.workerGroup()).option(ChannelOption.ALLOCATOR, (Object)this.allocator)).childOption(ChannelOption.ALLOCATOR, (Object)this.allocator).childHandler(this.channelInitializer());
        this.configureServer(bootstrap);
        ChannelFuture f = bootstrap.bind(this.bindAddress);
        try {
            f.await();
        }
        catch (InterruptedException ex) {
            throw new PortBindException(this.bindAddress, (Throwable)ex);
        }
        if (!f.isSuccess()) {
            throw new PortBindException(this.bindAddress, f.cause());
        }
        this.channel = f.channel();
        this.onChannelBound(this.channel);
        this.logStartupMessage();
    }

    protected void onStart() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        Channel channel = this.channel;
        if (channel == null) {
            return;
        }
        super.stop();
        this.onChannelClose(channel);
        ChannelFuture f = channel.close().awaitUninterruptibly();
        if (!f.isSuccess()) {
            this.log.warn("Failed to close channel " + String.valueOf(channel) + " for connector " + this.id(), f.cause());
        }
    }

    protected void logStartupMessage() {
    }
}

