/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.transport;

import io.netty.channel.IoHandlerFactory;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.unix.DomainSocketChannel;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorOption;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;

public final class EpollConnectorTransport
implements ConnectorTransport {
    @Override
    public String getName() {
        return "epoll";
    }

    @Override
    public boolean isAvailable() {
        return Epoll.isAvailable();
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public boolean supportsOption(ConnectorOption<?> option) {
        return option == ConnectorOption.TCP_FAST_OPEN || option == ConnectorOption.TCP_FAST_OPEN_CONNECT;
    }

    @Override
    public IoHandlerFactory createIoHandlerFactory() {
        return EpollIoHandler.newFactory();
    }

    public Class<? extends SocketChannel> socketChannelType() {
        return EpollSocketChannel.class;
    }

    public Class<EpollServerSocketChannel> serverSocketChannelType() {
        return EpollServerSocketChannel.class;
    }

    @Override
    public Class<? extends DomainSocketChannel> domainSocketChannelType() {
        return EpollDomainSocketChannel.class;
    }

    public Class<EpollServerDomainSocketChannel> serverDomainSocketChannelType() {
        return EpollServerDomainSocketChannel.class;
    }
}

