/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.security.basic;

import java.util.Map;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.security.AuthenticationResult;
import org.neo4j.bolt.security.basic.BasicAuthenticationResult;
import org.neo4j.bolt.security.error.AuthenticationException;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;

public class BasicAuthentication
implements Authentication {
    private final AuthManager authManager;

    public BasicAuthentication(AuthManager authManager) {
        this.authManager = authManager;
    }

    @Override
    public AuthenticationResult authenticate(Map<String, Object> authToken, ClientConnectionInfo connectionInfo) throws AuthenticationException {
        try {
            LoginContext loginContext = this.authManager.login(authToken, connectionInfo);
            switch (loginContext.subject().getAuthenticationResult()) {
                case SUCCESS: 
                case PASSWORD_CHANGE_REQUIRED: {
                    break;
                }
                case TOO_MANY_ATTEMPTS: {
                    throw AuthenticationException.rateLimit();
                }
                default: {
                    throw AuthenticationException.unauthorized();
                }
            }
            return new BasicAuthenticationResult(loginContext);
        }
        catch (InvalidAuthTokenException e) {
            throw new AuthenticationException(e.gqlStatusObject(), e.status(), e.legacyMessage());
        }
    }

    @Override
    public LoginContext impersonate(LoginContext context, String userToImpersonate) throws AuthenticationException {
        return this.authManager.impersonate(context, userToImpersonate);
    }
}

