/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.error.reader;

import java.util.Set;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.packstream.error.PackstreamException;

public class PackstreamReaderException
extends PackstreamException {
    protected PackstreamReaderException(ErrorGqlStatusObject gqlStatusObject, String message, String legacyMessage) {
        super(gqlStatusObject, message, legacyMessage);
    }

    protected PackstreamReaderException(ErrorGqlStatusObject gqlStatusObject, String message, String legacyMessage, Throwable cause) {
        super(gqlStatusObject, message, legacyMessage, cause);
    }

    public static PackstreamReaderException internalError(String msgTitle, String message) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new PackstreamReaderException(gql, ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gql, (String)message), message);
    }

    public static PackstreamReaderException duplicateMapKey(String key) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N54).withParam(GqlParams.StringParam.mapKey, key).build();
        String legacyMessage = "Duplicate map key: \"" + key + "\"";
        return new PackstreamReaderException(gql, ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gql, (String)legacyMessage), legacyMessage);
    }

    public static PackstreamReaderException illegalElement(String elementName, String description, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N60).withParam(GqlParams.StringParam.item, elementName).withParam(GqlParams.StringParam.msg, description).build();
        return new PackstreamReaderException(gql, ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gql, (String)legacyMessage), legacyMessage);
    }

    public static PackstreamReaderException unknownDriverInterfaceType(long type, Set<Long> expectedType) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N01).withParam(GqlParams.StringParam.value, "driver interface type").withParam(GqlParams.ListParam.valueTypeList, expectedType.stream().toList()).withParam(GqlParams.StringParam.valueType, String.valueOf(type)).build()).build();
        String legacyMessage = "Unknown driver interface type " + type;
        return new PackstreamReaderException(gql, ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gql, (String)legacyMessage), legacyMessage);
    }
}

