/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.packstream.error.reader.LimitExceededException;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.reader.UnexpectedStructException;
import org.neo4j.packstream.error.reader.UnexpectedTypeException;
import org.neo4j.packstream.error.reader.UnexpectedTypeMarkerException;
import org.neo4j.packstream.io.LengthPrefix;
import org.neo4j.packstream.io.Type;
import org.neo4j.packstream.io.TypeMarker;
import org.neo4j.packstream.io.function.Reader;
import org.neo4j.packstream.io.function.Writer;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.packstream.struct.StructWriter;

public final class PackstreamBuf
implements ReferenceCounted {
    private final ByteBuf delegate;

    private PackstreamBuf(ByteBuf delegate) {
        this.delegate = delegate;
    }

    public static PackstreamBuf alloc(ByteBufAllocator alloc) {
        if (alloc == null) {
            throw new NullPointerException("alloc cannot be null");
        }
        return PackstreamBuf.wrap(alloc.buffer());
    }

    public static PackstreamBuf allocUnpooled() {
        return PackstreamBuf.wrap(Unpooled.buffer());
    }

    public static PackstreamBuf wrap(ByteBuf delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate cannot be null");
        }
        return new PackstreamBuf(delegate);
    }

    public static PackstreamBuf wrapRetained(ByteBuf delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate cannot be null");
        }
        return new PackstreamBuf(delegate.retain());
    }

    public ByteBuf raw() {
        return this.delegate;
    }

    public void peek(Consumer<PackstreamBuf> consumer) {
        this.delegate.markReaderIndex();
        try {
            consumer.accept(this);
        }
        finally {
            this.delegate.resetReaderIndex();
        }
    }

    public <R> R peek(Function<PackstreamBuf, R> func) {
        this.delegate.markReaderIndex();
        try {
            R r = func.apply(this);
            return r;
        }
        finally {
            this.delegate.resetReaderIndex();
        }
    }

    public PackstreamBuf skip(Type type) throws PackstreamReaderException {
        switch (type) {
            case NONE: {
                this.skipNull();
                break;
            }
            case BOOLEAN: {
                this.skipBoolean();
                break;
            }
            case BYTES: {
                this.skipBytes(-1L);
                break;
            }
            case FLOAT: {
                this.skipFloat64();
                break;
            }
            case INT: {
                this.skipInt();
                break;
            }
            case LIST: {
                this.skipList(-1L);
                break;
            }
            case MAP: {
                this.skipMap(-1L);
                break;
            }
            case STRING: {
                this.skipString(-1L);
                break;
            }
            case STRUCT: {
                this.skipStruct();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type: " + String.valueOf((Object)type));
            }
        }
        return this;
    }

    public PackstreamBuf skip() throws PackstreamReaderException {
        return this.skip(this.peekType());
    }

    public short readMarkerByte() {
        return this.delegate.readUnsignedByte();
    }

    public TypeMarker readMarker() {
        return TypeMarker.byEncoded(this.readMarkerByte());
    }

    public long readExpectedMarker(TypeMarker expected) throws UnexpectedTypeMarkerException {
        short mb = this.readMarkerByte();
        TypeMarker actual = TypeMarker.byEncoded(mb);
        if (actual != expected) {
            throw UnexpectedTypeMarkerException.wrongType(String.valueOf(mb), expected, actual);
        }
        if (expected.getLengthPrefix() == LengthPrefix.NIBBLE) {
            return TypeMarker.decodeLengthNibble(mb);
        }
        return mb;
    }

    public long readLengthPrefixMarker(Type type, long limit) throws UnexpectedTypeException, LimitExceededException {
        short mb = this.readMarkerByte();
        TypeMarker marker = TypeMarker.byEncoded(mb);
        if (marker.getType() != type) {
            throw UnexpectedTypeException.invalidType(type, marker);
        }
        long length = marker.isNibbleMarker() ? (long)TypeMarker.decodeLengthNibble(mb) : marker.getLengthPrefix().readFrom(this.delegate);
        if (limit > 0L && length > limit) {
            throw LimitExceededException.protocolMessageLengthLimitOverflow(limit, length);
        }
        return length;
    }

    public long readLengthPrefixMarker(Type type) throws UnexpectedTypeException, LimitExceededException {
        return this.readLengthPrefixMarker(type, -1L);
    }

    public short peekMarkerByte() {
        return this.delegate.getUnsignedByte(this.delegate.readerIndex());
    }

    public TypeMarker peekMarker() {
        return TypeMarker.byEncoded(this.peekMarkerByte());
    }

    public Type peekType() {
        return this.peekMarker().getType();
    }

    public PackstreamBuf writeMarkerByte(int marker) {
        this.delegate.writeByte(marker);
        return this;
    }

    public PackstreamBuf writeMarker(TypeMarker type) {
        if (type.hasLengthPrefix()) {
            throw new IllegalArgumentException("Type " + String.valueOf((Object)type) + " requires a length");
        }
        this.writeMarkerByte(type.getValue());
        return this;
    }

    public PackstreamBuf writeMarker(TypeMarker marker, long length) {
        if (!marker.hasLengthPrefix()) {
            throw new IllegalArgumentException("Type " + String.valueOf((Object)marker) + " does not provide length");
        }
        if (!marker.canEncodeLength(length)) {
            throw new IllegalArgumentException("Type " + String.valueOf((Object)marker) + " cannot store value of length " + length + " (limit is " + marker.getLengthPrefix().getMaxValue() + ")");
        }
        TypeMarker.requireEncodableLength(marker, length);
        if (marker.isNibbleMarker()) {
            this.writeMarkerByte(TypeMarker.encodeLengthNibble(marker, (int)length));
            return this;
        }
        this.writeMarkerByte(marker.getValue());
        marker.getLengthPrefix().writeTo(this.delegate, length);
        return this;
    }

    public PackstreamBuf writeMarker(Collection<TypeMarker> markers, long length) {
        if (markers.isEmpty()) {
            throw new IllegalArgumentException("Marker collection cannot be empty");
        }
        for (TypeMarker marker2 : markers) {
            if (!marker2.hasLengthPrefix() || !marker2.canEncodeLength(length)) continue;
            return this.writeMarker(marker2, length);
        }
        String maxLengths = markers.stream().filter(TypeMarker::hasLengthPrefix).map(marker -> marker.getLengthPrefix().getMaxValue() + " (" + marker.name() + ")").collect(Collectors.joining(", "));
        throw new IllegalArgumentException("Length " + length + " exceeds supported maximum lengths of " + maxLengths);
    }

    public PackstreamBuf writeValue(Object payload) {
        if (payload == null) {
            return this.writeNull();
        }
        if (payload instanceof byte[]) {
            byte[] b = (byte[])payload;
            return this.writeBytes(Unpooled.wrappedBuffer((byte[])b));
        }
        if (payload instanceof ByteBuffer) {
            ByteBuffer b = (ByteBuffer)payload;
            return this.writeBytes(Unpooled.wrappedBuffer((ByteBuffer)b));
        }
        if (payload instanceof ByteBuf) {
            ByteBuf b = (ByteBuf)payload;
            return this.writeBytes(b);
        }
        if (payload instanceof Boolean) {
            Boolean b = (Boolean)payload;
            return this.writeBoolean(b);
        }
        if (payload instanceof Float) {
            Float f = (Float)payload;
            return this.writeFloat64(f.floatValue());
        }
        if (payload instanceof Byte) {
            Byte b = (Byte)payload;
            return this.writeInt(b.byteValue());
        }
        if (payload instanceof Short) {
            Short s = (Short)payload;
            return this.writeInt(s.shortValue());
        }
        if (payload instanceof Integer) {
            Integer i = (Integer)payload;
            return this.writeInt(i.intValue());
        }
        if (payload instanceof Long) {
            Long l = (Long)payload;
            return this.writeInt(l);
        }
        if (payload instanceof List) {
            List l = (List)payload;
            return this.writeList(l);
        }
        if (payload instanceof Map) {
            Map m = (Map)payload;
            return this.writeMap(m);
        }
        if (payload instanceof String) {
            String s = (String)payload;
            return this.writeString(s);
        }
        throw new IllegalArgumentException("Unsupported value of type " + payload.getClass().getName() + ": " + String.valueOf(payload));
    }

    public PackstreamBuf readNull() throws UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.NULL);
        return this;
    }

    public PackstreamBuf skipNull() throws UnexpectedTypeException {
        return this.readNull();
    }

    public PackstreamBuf writeNull() {
        return this.writeMarker(TypeMarker.NULL);
    }

    public boolean readBoolean() throws UnexpectedTypeException {
        TypeMarker marker = this.readMarker();
        if (marker.getType() != Type.BOOLEAN) {
            throw UnexpectedTypeException.invalidType(Type.BOOLEAN, marker);
        }
        return marker == TypeMarker.TRUE;
    }

    public PackstreamBuf skipBoolean() throws UnexpectedTypeException {
        TypeMarker marker = this.readMarker();
        if (marker.getType() != Type.BOOLEAN) {
            throw UnexpectedTypeException.invalidType(Type.BOOLEAN, marker);
        }
        return this;
    }

    public PackstreamBuf writeBoolean(boolean payload) {
        if (payload) {
            return this.writeMarker(TypeMarker.TRUE);
        }
        return this.writeMarker(TypeMarker.FALSE);
    }

    public long readInt() throws UnexpectedTypeException {
        short m = this.readMarkerByte();
        TypeMarker marker = TypeMarker.byEncoded(m);
        if (marker.getType() != Type.INT) {
            throw UnexpectedTypeException.invalidType(Type.INT, marker);
        }
        return switch (marker) {
            case TypeMarker.TINY_INT -> (byte)m;
            case TypeMarker.INT8 -> this.delegate.readByte();
            case TypeMarker.INT16 -> this.delegate.readShort();
            case TypeMarker.INT32 -> this.delegate.readInt();
            default -> this.delegate.readLong();
        };
    }

    public PackstreamBuf skipInt() throws UnexpectedTypeException {
        short m = this.readMarkerByte();
        TypeMarker marker = TypeMarker.byEncoded(m);
        if (marker.getType() != Type.INT) {
            throw UnexpectedTypeException.invalidType(Type.INT, marker);
        }
        switch (marker) {
            case TINY_INT: {
                break;
            }
            case INT8: {
                this.delegate.skipBytes(1);
                break;
            }
            case INT16: {
                this.delegate.skipBytes(2);
                break;
            }
            case INT32: {
                this.delegate.skipBytes(4);
                break;
            }
            default: {
                this.delegate.skipBytes(8);
            }
        }
        return this;
    }

    public PackstreamBuf writeInt(long value) {
        if (value >= -16L && value <= 127L) {
            return this.writeTinyInt((byte)value);
        }
        if (value >= -128L && value <= -16L) {
            return this.writeInt8((byte)value);
        }
        if (value >= -32768L && value <= 32767L) {
            return this.writeInt16((short)value);
        }
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return this.writeInt32((int)value);
        }
        return this.writeInt64(value);
    }

    public byte readTinyInt() throws UnexpectedTypeMarkerException {
        return (byte)this.readExpectedMarker(TypeMarker.TINY_INT);
    }

    public PackstreamBuf writeTinyInt(byte value) {
        if ((long)value < -16L) {
            throw new IllegalArgumentException("Value is out of type bounds: " + value);
        }
        return this.writeMarkerByte(TypeMarker.encodeLengthNibble(TypeMarker.TINY_INT, value));
    }

    public byte readInt8() throws UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.INT8);
        return this.delegate.readByte();
    }

    public PackstreamBuf writeInt8(byte value) {
        this.writeMarker(TypeMarker.INT8);
        this.delegate.writeByte((int)value);
        return this;
    }

    public short readInt16() throws UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.INT16);
        return this.delegate.readShort();
    }

    public PackstreamBuf writeInt16(short value) {
        this.writeMarker(TypeMarker.INT16);
        this.delegate.writeShort((int)value);
        return this;
    }

    public int readInt32() throws UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.INT32);
        return this.delegate.readInt();
    }

    public PackstreamBuf writeInt32(int value) {
        this.writeMarker(TypeMarker.INT32);
        this.delegate.writeInt(value);
        return this;
    }

    public long readInt64() throws UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.INT64);
        return this.delegate.readLong();
    }

    public PackstreamBuf writeInt64(long value) {
        this.writeMarker(TypeMarker.INT64);
        this.delegate.writeLong(value);
        return this;
    }

    public float readFloat32() throws UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.FLOAT32);
        return this.delegate.readFloat();
    }

    public PackstreamBuf skipFloat32() throws UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.FLOAT32);
        this.delegate.skipBytes(4);
        return this;
    }

    public PackstreamBuf writeFloat32(float value) {
        this.writeMarker(TypeMarker.FLOAT32);
        this.delegate.writeFloat(value);
        return this;
    }

    public double readFloat64() throws UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.FLOAT64);
        return this.delegate.readDouble();
    }

    public PackstreamBuf skipFloat64() throws UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.FLOAT64);
        this.delegate.skipBytes(8);
        return this;
    }

    public PackstreamBuf writeFloat64(double payload) {
        this.writeMarker(TypeMarker.FLOAT64);
        this.delegate.writeDouble(payload);
        return this;
    }

    public ByteBuf readBytes(long limit) throws PackstreamReaderException {
        TypeMarker marker = this.readMarker();
        if (marker.getType() != Type.BYTES) {
            throw UnexpectedTypeException.invalidType(Type.BYTES, marker);
        }
        long length = marker.getLengthPrefix().readFrom(this.delegate);
        if (limit > 0L && length > limit) {
            throw LimitExceededException.protocolMessageLengthLimitOverflow(limit, length);
        }
        return this.readBytesValue(length);
    }

    public PackstreamBuf skipBytes(long limit) throws PackstreamReaderException {
        int part;
        long length;
        TypeMarker marker = this.readMarker();
        if (marker.getType() != Type.BYTES) {
            throw UnexpectedTypeException.invalidType(Type.BYTES, marker);
        }
        if (limit > 0L && length > limit) {
            throw LimitExceededException.protocolMessageLengthLimitOverflow(limit, length);
        }
        for (length = marker.getLengthPrefix().readFrom(this.delegate); length > 0L; length -= (long)part) {
            part = (int)length;
            this.delegate.skipBytes(part);
        }
        return this;
    }

    public PackstreamBuf writeBytes(ByteBuf bytes) {
        this.writeMarker(TypeMarker.BYTES_TYPES, (long)bytes.readableBytes());
        this.delegate.writeBytes(bytes);
        return this;
    }

    public ByteBuf readBytes() throws PackstreamReaderException {
        return this.readBytes(-1L);
    }

    private ByteBuf readBytesValue(long length) throws LimitExceededException {
        if (length > Integer.MAX_VALUE) {
            throw LimitExceededException.protocolMessageLengthLimitOverflow(Integer.MAX_VALUE, length);
        }
        return this.delegate.readSlice((int)length);
    }

    public ByteBuf readBytes8() throws LimitExceededException, UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.BYTES8);
        long length = LengthPrefix.UINT8.readFrom(this.delegate);
        return this.readBytesValue(length);
    }

    public PackstreamBuf writeBytes8(ByteBuf bytes) {
        this.writeMarker(TypeMarker.BYTES8, (long)bytes.readableBytes());
        this.delegate.writeBytes(bytes);
        return this;
    }

    public ByteBuf readBytes16() throws LimitExceededException, UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.BYTES16);
        long length = LengthPrefix.UINT16.readFrom(this.delegate);
        return this.readBytesValue(length);
    }

    public PackstreamBuf writeBytes16(ByteBuf bytes) {
        this.writeMarker(TypeMarker.BYTES16, (long)bytes.readableBytes());
        this.delegate.writeBytes(bytes);
        return this;
    }

    public ByteBuf readBytes32() throws LimitExceededException, UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.BYTES32);
        long length = LengthPrefix.UINT32.readFrom(this.delegate);
        return this.readBytesValue(length);
    }

    public PackstreamBuf writeBytes32(ByteBuf bytes) {
        this.writeMarker(TypeMarker.BYTES32, (long)bytes.readableBytes());
        this.delegate.writeBytes(bytes);
        return this;
    }

    public String readString(long limit) throws UnexpectedTypeException, LimitExceededException {
        long length = this.readLengthPrefixMarker(Type.STRING, limit);
        return this.readStringValue(length);
    }

    public PackstreamBuf skipString(long limit) throws UnexpectedTypeException, LimitExceededException {
        int part;
        for (long length = this.readLengthPrefixMarker(Type.STRING, limit); length > 0L; length -= (long)part) {
            part = (int)length;
            this.delegate.skipBytes(part);
        }
        return this;
    }

    public String readString() throws PackstreamReaderException {
        return this.readString(-1L);
    }

    private String readStringValue(long length) throws LimitExceededException {
        ByteBuf heap = this.readBytesValue(length);
        return heap.toString(Type.STRING_CHARSET);
    }

    public PackstreamBuf writeString(String payload) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeString(payload.getBytes(Type.STRING_CHARSET));
    }

    private PackstreamBuf writeString(byte[] payload) {
        return this.writeString(payload, 0, payload.length);
    }

    public PackstreamBuf writeString(byte[] payload, int offset, int length) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        this.writeMarker(TypeMarker.STRING_TYPES, (long)length);
        this.delegate.writeBytes(payload, offset, length);
        return this;
    }

    public String readTinyString() throws LimitExceededException, UnexpectedTypeMarkerException {
        long length = this.readExpectedMarker(TypeMarker.TINY_STRING);
        return this.readStringValue(length);
    }

    public PackstreamBuf writeTinyString(String payload) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeTinyString(payload.getBytes(Type.STRING_CHARSET));
    }

    private PackstreamBuf writeTinyString(byte[] payload) {
        this.writeMarker(TypeMarker.TINY_STRING, (long)payload.length);
        this.delegate.writeBytes(payload);
        return this;
    }

    public String readString8() throws LimitExceededException, UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.STRING8);
        long length = LengthPrefix.UINT8.readFrom(this.delegate);
        return this.readStringValue(length);
    }

    public PackstreamBuf writeString8(String payload) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeString8(payload.getBytes(Type.STRING_CHARSET));
    }

    private PackstreamBuf writeString8(byte[] payload) {
        this.writeMarker(TypeMarker.STRING8, (long)payload.length);
        this.delegate.writeBytes(payload);
        return this;
    }

    public String readString16() throws LimitExceededException, UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.STRING16);
        long length = LengthPrefix.UINT16.readFrom(this.delegate);
        return this.readStringValue(length);
    }

    public PackstreamBuf writeString16(String payload) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeString16(payload.getBytes(Type.STRING_CHARSET));
    }

    private PackstreamBuf writeString16(byte[] payload) {
        this.writeMarker(TypeMarker.STRING16, (long)payload.length);
        this.delegate.writeBytes(payload);
        return this;
    }

    public String readString32() throws LimitExceededException, UnexpectedTypeMarkerException {
        this.readExpectedMarker(TypeMarker.STRING32);
        long length = LengthPrefix.UINT32.readFrom(this.delegate);
        return this.readStringValue(length);
    }

    public PackstreamBuf writeString32(String payload) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeString32(payload.getBytes(Type.STRING_CHARSET));
    }

    private PackstreamBuf writeString32(byte[] payload) {
        this.writeMarker(TypeMarker.STRING32, (long)payload.length);
        this.delegate.writeBytes(payload);
        return this;
    }

    private <O> List<O> readListValue(long length, Reader<O> reader) throws PackstreamReaderException {
        if (length > Integer.MAX_VALUE) {
            throw LimitExceededException.protocolMessageLengthLimitOverflow(Integer.MAX_VALUE, length);
        }
        ArrayList<O> elements = new ArrayList<O>();
        int i = 0;
        while ((long)i < length) {
            elements.add(reader.read(this));
            ++i;
        }
        return elements;
    }

    public <O> List<O> readList(long limit, Reader<O> reader) throws PackstreamReaderException {
        long length = this.readLengthPrefixMarker(Type.LIST, limit);
        return this.readListValue(length, reader);
    }

    public PackstreamBuf skipList(long limit) throws PackstreamReaderException {
        long length = this.readLengthPrefixMarker(Type.LIST, limit);
        for (long i = 0L; i < length; ++i) {
            this.skip();
        }
        return this;
    }

    public <O> List<O> readList(Reader<O> reader) throws PackstreamReaderException {
        return this.readList(-1L, reader);
    }

    private <I> PackstreamBuf writeListValue(Collection<I> payload, Writer<I> writer) {
        payload.forEach(element -> writer.write(this, element));
        return this;
    }

    public PackstreamBuf writeListHeader(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size cannot be negative");
        }
        return this.writeMarker(TypeMarker.LIST_TYPES, (long)size);
    }

    public <I> PackstreamBuf writeList(Collection<I> payload, Writer<I> writer) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeListHeader(payload.size()).writeListValue(payload, writer);
    }

    public PackstreamBuf writeList(List<Object> payload) {
        return this.writeList(payload, PackstreamBuf::writeValue);
    }

    public <O> List<O> readTinyList(Reader<O> reader) throws PackstreamReaderException {
        long length = this.readExpectedMarker(TypeMarker.TINY_LIST);
        return this.readListValue(length, reader);
    }

    public <I> PackstreamBuf writeTinyList(Collection<I> payload, Writer<I> writer) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeMarker(TypeMarker.TINY_LIST, (long)payload.size()).writeListValue(payload, writer);
    }

    public <O> List<O> readList8(Reader<O> reader) throws PackstreamReaderException {
        this.readExpectedMarker(TypeMarker.LIST8);
        long length = LengthPrefix.UINT8.readFrom(this.delegate);
        return this.readListValue(length, reader);
    }

    public <I> PackstreamBuf writeList8(Collection<I> payload, Writer<I> writer) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeMarker(TypeMarker.LIST8, (long)payload.size()).writeListValue(payload, writer);
    }

    public <O> List<O> readList16(Reader<O> reader) throws PackstreamReaderException {
        this.readExpectedMarker(TypeMarker.LIST16);
        long length = LengthPrefix.UINT16.readFrom(this.delegate);
        return this.readListValue(length, reader);
    }

    public <I> PackstreamBuf writeList16(Collection<I> payload, Writer<I> writer) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeMarker(TypeMarker.LIST16, (long)payload.size()).writeListValue(payload, writer);
    }

    public <O> List<O> readList32(Reader<O> reader) throws PackstreamReaderException {
        this.readExpectedMarker(TypeMarker.LIST32);
        long length = LengthPrefix.UINT32.readFrom(this.delegate);
        return this.readListValue(length, reader);
    }

    public <I> PackstreamBuf writeList32(Collection<I> payload, Writer<I> writer) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeMarker(TypeMarker.LIST32, (long)payload.size()).writeListValue(payload, writer);
    }

    private <O> Map<String, O> readMapValue(long length, Reader<O> reader) throws PackstreamReaderException {
        if (length > Integer.MAX_VALUE) {
            throw LimitExceededException.protocolMessageLengthLimitOverflow(Integer.MAX_VALUE, length);
        }
        HashMap<String, O> elements = new HashMap<String, O>();
        int i = 0;
        while ((long)i < length) {
            String key = this.readString();
            if (elements.containsKey(key)) {
                throw PackstreamReaderException.duplicateMapKey(key);
            }
            O value = reader.read(this);
            elements.put(key, value);
            ++i;
        }
        return elements;
    }

    private <I> PackstreamBuf writeMapValue(Map<String, I> payload, Writer<I> writer) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        payload.forEach((key, value) -> {
            this.writeString((String)key);
            writer.write(this, value);
        });
        return this;
    }

    public PackstreamBuf writeMapHeader(long length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("length exceeds limit of 2147483647");
        }
        return this.writeMarker(TypeMarker.MAP_TYPES, length);
    }

    public <O> Map<String, O> readMap(long limit, Reader<O> reader) throws PackstreamReaderException {
        long length = this.readLengthPrefixMarker(Type.MAP, limit);
        if (limit > 0L && length > limit) {
            throw LimitExceededException.protocolMessageLengthLimitOverflow(limit, length);
        }
        return this.readMapValue(length, reader);
    }

    public PackstreamBuf skipMap(long limit) throws PackstreamReaderException {
        long length = this.readLengthPrefixMarker(Type.MAP, limit);
        if (limit > 0L && length > limit) {
            throw LimitExceededException.protocolMessageLengthLimitOverflow(limit, length);
        }
        int i = 0;
        while ((long)i < length) {
            this.skipString(-1L);
            this.skip();
            ++i;
        }
        return this;
    }

    public <O> Map<String, O> readMap(Reader<O> reader) throws PackstreamReaderException {
        return this.readMap(-1L, reader);
    }

    public <I> PackstreamBuf writeMap(Map<String, I> payload, Writer<I> writer) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeMapHeader(payload.size()).writeMapValue(payload, writer);
    }

    public PackstreamBuf writeMap(Map<String, Object> payload) {
        return this.writeMap(payload, PackstreamBuf::writeValue);
    }

    public <O> Map<String, O> readTinyMap(Reader<O> reader) throws PackstreamReaderException {
        long length = this.readExpectedMarker(TypeMarker.TINY_MAP);
        return this.readMapValue(length, reader);
    }

    public <I> PackstreamBuf writeTinyMap(Map<String, I> payload, Writer<I> writer) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeMarker(TypeMarker.TINY_MAP, (long)payload.size()).writeMapValue(payload, writer);
    }

    public <O> Map<String, O> readMap8(Reader<O> reader) throws PackstreamReaderException {
        this.readExpectedMarker(TypeMarker.MAP8);
        long length = LengthPrefix.UINT8.readFrom(this.delegate);
        return this.readMapValue(length, reader);
    }

    public <I> PackstreamBuf writeMap8(Map<String, I> payload, Writer<I> writer) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeMarker(TypeMarker.MAP8, (long)payload.size()).writeMapValue(payload, writer);
    }

    public <O> Map<String, O> readMap16(Reader<O> reader) throws PackstreamReaderException {
        this.readExpectedMarker(TypeMarker.MAP16);
        long length = LengthPrefix.UINT16.readFrom(this.delegate);
        return this.readMapValue(length, reader);
    }

    public <I> PackstreamBuf writeMap16(Map<String, I> payload, Writer<I> writer) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeMarker(TypeMarker.MAP16, (long)payload.size()).writeMapValue(payload, writer);
    }

    public <O> Map<String, O> readMap32(Reader<O> reader) throws PackstreamReaderException {
        this.readExpectedMarker(TypeMarker.MAP32);
        long length = LengthPrefix.UINT32.readFrom(this.delegate);
        return this.readMapValue(length, reader);
    }

    public <I> PackstreamBuf writeMap32(Map<String, I> payload, Writer<I> writer) {
        if (payload == null) {
            throw new NullPointerException("payload cannot be null");
        }
        return this.writeMarker(TypeMarker.MAP32, (long)payload.size()).writeMapValue(payload, writer);
    }

    public StructHeader peekStructHeader() throws LimitExceededException, UnexpectedTypeException {
        int originalMarkerLocation = this.delegate.readerIndex();
        try {
            this.delegate.markReaderIndex();
            StructHeader structHeader = this.readStructHeader();
            return structHeader;
        }
        finally {
            this.delegate.resetReaderIndex().readerIndex(originalMarkerLocation);
        }
    }

    public StructHeader readStructHeader() throws LimitExceededException, UnexpectedTypeException {
        long length = this.readLengthPrefixMarker(Type.STRUCT);
        short tag = this.delegate.readUnsignedByte();
        return new StructHeader(length, tag);
    }

    public PackstreamBuf writeStructHeader(StructHeader header) {
        this.writeMarker(TypeMarker.STRUCT_TYPES, header.length());
        this.delegate.writeByte((int)header.tag());
        return this;
    }

    public <CTX, O> O readStruct(CTX ctx, StructRegistry<CTX, O> registry) throws PackstreamReaderException {
        StructHeader header = this.readStructHeader();
        return registry.getReader(header).orElseThrow(() -> UnexpectedStructException.unexpectedStruct(header)).read(ctx, this, header);
    }

    public PackstreamBuf skipStruct() throws PackstreamReaderException {
        StructHeader header = this.readStructHeader();
        int i = 0;
        while ((long)i < header.length()) {
            this.skip();
            ++i;
        }
        return this;
    }

    public <CTX, S, P extends S> PackstreamBuf writeStruct(CTX ctx, StructRegistry<CTX, S> registry, P payload) {
        if (registry == null) {
            throw new NullPointerException("registry cannot be null");
        }
        StructWriter<CTX, P> writer = registry.getWriter(payload).orElseThrow(() -> new IllegalArgumentException("Illegal struct: " + String.valueOf(payload)));
        short tag = writer.getTag(payload);
        long length = writer.getLength(payload);
        StructHeader header = new StructHeader(length, tag);
        this.writeStructHeader(header);
        writer.write(ctx, this, payload);
        return this;
    }

    public int refCnt() {
        return this.delegate.refCnt();
    }

    public ReferenceCounted retain() {
        this.delegate.retain();
        return this;
    }

    public ReferenceCounted retain(int i) {
        this.delegate.retain(i);
        return this;
    }

    public ReferenceCounted touch() {
        this.delegate.touch();
        return this;
    }

    public ReferenceCounted touch(Object o) {
        this.delegate.touch(o);
        return this;
    }

    public boolean release() {
        return this.delegate.release();
    }

    public boolean release(int i) {
        return this.delegate.release(i);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackstreamBuf that = (PackstreamBuf)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

