/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.security.auth;

import java.io.IOException;
import java.util.Map;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.security.auth.BasicAuthenticationResult;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;

public class BasicAuthentication
implements Authentication {
    private final AuthManager authManager;

    public BasicAuthentication(AuthManager authManager) {
        this.authManager = authManager;
    }

    @Override
    public AuthenticationResult authenticate(Map<String, Object> authToken) throws AuthenticationException {
        if (authToken.containsKey("new_credentials")) {
            return this.update(authToken, false);
        }
        return this.doAuthenticate(authToken);
    }

    private AuthenticationResult doAuthenticate(Map<String, Object> authToken) throws AuthenticationException {
        try {
            SecurityContext securityContext = this.authManager.login(authToken);
            switch (securityContext.subject().getAuthenticationResult()) {
                case SUCCESS: 
                case PASSWORD_CHANGE_REQUIRED: {
                    break;
                }
                case TOO_MANY_ATTEMPTS: {
                    throw new AuthenticationException((Status)Status.Security.AuthenticationRateLimit);
                }
                default: {
                    throw new AuthenticationException((Status)Status.Security.Unauthorized);
                }
            }
            return new BasicAuthenticationResult(securityContext);
        }
        catch (InvalidAuthTokenException e) {
            throw new AuthenticationException(e.status(), e.getMessage());
        }
    }

    private AuthenticationResult update(Map<String, Object> authToken, boolean requiresPasswordChange) throws AuthenticationException {
        try {
            SecurityContext securityContext = this.authManager.login(authToken);
            switch (securityContext.subject().getAuthenticationResult()) {
                case SUCCESS: 
                case PASSWORD_CHANGE_REQUIRED: {
                    String newPassword = AuthToken.safeCast((String)"new_credentials", authToken);
                    securityContext.subject().setPassword(newPassword, requiresPasswordChange);
                    break;
                }
                default: {
                    throw new AuthenticationException((Status)Status.Security.Unauthorized);
                }
            }
            return new BasicAuthenticationResult(securityContext);
        }
        catch (AuthorizationViolationException | InvalidArgumentsException | InvalidAuthTokenException e) {
            throw new AuthenticationException(((Status.HasStatus)e).status(), e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AuthenticationException((Status)Status.Security.Unauthorized, e.getMessage(), e);
        }
    }
}

