/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import java.util.Map;
import java.util.function.BiFunction;
import org.neo4j.bolt.transport.BoltProtocol;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.bolt.transport.TransportSelectionHandler;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.logging.LogProvider;

public class SocketTransport
implements NettyServer.ProtocolInitializer {
    private final ListenSocketAddress address;
    private final SslContext sslCtx;
    private final boolean encryptionRequired;
    private LogProvider logging;
    private final Map<Long, BiFunction<Channel, Boolean, BoltProtocol>> protocolVersions;

    public SocketTransport(ListenSocketAddress address, SslContext sslCtx, boolean encryptionRequired, LogProvider logging, Map<Long, BiFunction<Channel, Boolean, BoltProtocol>> protocolVersions) {
        this.address = address;
        this.sslCtx = sslCtx;
        this.encryptionRequired = encryptionRequired;
        this.logging = logging;
        this.protocolVersions = protocolVersions;
    }

    @Override
    public ChannelInitializer<SocketChannel> channelInitializer() {
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
                ch.pipeline().addLast(new ChannelHandler[]{new TransportSelectionHandler(SocketTransport.this.sslCtx, SocketTransport.this.encryptionRequired, false, SocketTransport.this.logging, SocketTransport.this.protocolVersions)});
            }
        };
    }

    @Override
    public ListenSocketAddress address() {
        return this.address;
    }
}

