/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.infrastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.infrastructure.ValuePropertyContainer;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.Status;

public class ValueNode
extends ValuePropertyContainer
implements Node {
    private static final int STRUCT_FIELD_COUNT = 3;
    private final long id;
    private final Collection<Label> labels;

    public static void pack(Neo4jPack.Packer packer, Node node) throws IOException {
        packer.packStructHeader(3, (byte)78);
        packer.pack(node.getId());
        try {
            List collectedLabels = Iterables.asList((Iterable)node.getLabels());
            Map props = node.getAllProperties();
            packer.packListHeader(collectedLabels.size());
            for (Label label : collectedLabels) {
                packer.pack(label.name());
            }
            packer.packRawMap(props);
        }
        catch (NotFoundException e) {
            packer.packListHeader(0);
            packer.packRawMap(Collections.emptyMap());
        }
    }

    public static ValueNode unpack(Neo4jPack.Unpacker unpacker) throws IOException {
        long numFields = unpacker.unpackStructHeader();
        char signature = unpacker.unpackStructSignature();
        if (signature != 'N') {
            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Expected a node structure, received 0x" + Integer.toHexString(signature));
        }
        if (numFields != 3L) {
            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Node structures should have 3 fields, structure sent contained " + numFields);
        }
        return ValueNode.unpackFields(unpacker);
    }

    public static ValueNode unpackFields(Neo4jPack.Unpacker unpacker) throws IOException {
        List<Label> labels;
        long id = unpacker.unpackLong();
        int numLabels = (int)unpacker.unpackListHeader();
        if (numLabels > 0) {
            labels = new ArrayList(numLabels);
            for (int i = 0; i < numLabels; ++i) {
                labels.add(Label.label((String)unpacker.unpackString()));
            }
        } else {
            labels = Collections.emptyList();
        }
        Map<String, Object> props = unpacker.unpackMap();
        return new ValueNode(id, labels, props);
    }

    public ValueNode(long id, Collection<Label> labels, Map<String, Object> props) {
        super(props);
        this.id = id;
        this.labels = labels;
    }

    public long getId() {
        return this.id;
    }

    public Iterable<Label> getLabels() {
        return this.labels;
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public Iterable<Relationship> getRelationships() {
        throw new UnsupportedOperationException();
    }

    public boolean hasRelationship() {
        throw new UnsupportedOperationException();
    }

    public Iterable<Relationship> getRelationships(RelationshipType ... relationshipTypes) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... relationshipTypes) {
        throw new UnsupportedOperationException();
    }

    public boolean hasRelationship(RelationshipType ... relationshipTypes) {
        throw new UnsupportedOperationException();
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... relationshipTypes) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Relationship> getRelationships(Direction direction) {
        throw new UnsupportedOperationException();
    }

    public boolean hasRelationship(Direction direction) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Relationship> getRelationships(RelationshipType relationshipType, Direction direction) {
        throw new UnsupportedOperationException();
    }

    public boolean hasRelationship(RelationshipType relationshipType, Direction direction) {
        throw new UnsupportedOperationException();
    }

    public Relationship getSingleRelationship(RelationshipType relationshipType, Direction direction) {
        throw new UnsupportedOperationException();
    }

    public Relationship createRelationshipTo(Node node, RelationshipType relationshipType) {
        throw new UnsupportedOperationException();
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        throw new UnsupportedOperationException();
    }

    public int getDegree() {
        throw new UnsupportedOperationException();
    }

    public int getDegree(RelationshipType relationshipType) {
        throw new UnsupportedOperationException();
    }

    public int getDegree(Direction direction) {
        throw new UnsupportedOperationException();
    }

    public int getDegree(RelationshipType relationshipType, Direction direction) {
        throw new UnsupportedOperationException();
    }

    public void addLabel(Label label) {
        throw new UnsupportedOperationException();
    }

    public void removeLabel(Label label) {
        throw new UnsupportedOperationException();
    }

    public boolean hasLabel(Label label) {
        throw new UnsupportedOperationException();
    }

    public GraphDatabaseService getGraphDatabase() {
        throw new UnsupportedOperationException();
    }

    public boolean hasProperty(String s) {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String s, Object o) {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String s, Object o) {
        throw new UnsupportedOperationException();
    }

    public Object removeProperty(String s) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueNode valueNode = (ValueNode)o;
        return this.id == valueNode.id && this.labels.equals(valueNode.labels);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.labels.hashCode();
        result = 31 * result + this.getAllProperties().hashCode();
        return result;
    }

    public String toString() {
        return "ValueNode{id=" + this.id + ", labels=" + this.labels + ", props=" + this.getAllProperties() + '}';
    }
}

