/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.infrastructure;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.infrastructure.ValueNode;
import org.neo4j.bolt.v1.messaging.infrastructure.ValuePropertyContainer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.api.exceptions.Status;

public class ValueRelationship
extends ValuePropertyContainer
implements Relationship {
    private static final int STRUCT_FIELD_COUNT = 5;
    private final long id;
    private final long startNode;
    private final long endNode;
    private final RelationshipType type;

    public static void pack(Neo4jPack.Packer packer, Relationship rel) throws IOException {
        packer.packStructHeader(5, (byte)82);
        packer.pack(rel.getId());
        packer.pack(rel.getStartNode().getId());
        packer.pack(rel.getEndNode().getId());
        packer.pack(rel.getType().name());
        try {
            Map properties = rel.getAllProperties();
            packer.packRawMap(properties);
        }
        catch (NotFoundException e) {
            packer.packRawMap(Collections.emptyMap());
        }
    }

    public static ValueRelationship unpack(Neo4jPack.Unpacker unpacker) throws IOException {
        long numFields = unpacker.unpackStructHeader();
        char signature = unpacker.unpackStructSignature();
        if (signature != 'R') {
            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Expected a relationship structure, recieved 0x" + Integer.toHexString(signature));
        }
        if (numFields != 5L) {
            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Relationship structures should have 5 fields, structure sent contained " + numFields);
        }
        return ValueRelationship.unpackFields(unpacker);
    }

    public static ValueRelationship unpackFields(Neo4jPack.Unpacker unpacker) throws IOException {
        long relId = unpacker.unpackLong();
        long startNodeId = unpacker.unpackLong();
        long endNodeId = unpacker.unpackLong();
        String relTypeName = unpacker.unpackString();
        Map<String, Object> props = unpacker.unpackMap();
        RelationshipType relType = RelationshipType.withName((String)relTypeName);
        return new ValueRelationship(relId, startNodeId, endNodeId, relType, props);
    }

    public ValueRelationship(long id, long from, long to, RelationshipType type, Map<String, Object> props) {
        super(props);
        this.id = id;
        this.startNode = from;
        this.endNode = to;
        this.type = type;
    }

    public long getId() {
        return this.id;
    }

    public Node getStartNode() {
        return new ValueNode(this.startNode, null, null);
    }

    public Node getEndNode() {
        return new ValueNode(this.endNode, null, null);
    }

    public RelationshipType getType() {
        return this.type;
    }

    public Node getOtherNode(Node node) {
        throw new UnsupportedOperationException();
    }

    public Node[] getNodes() {
        throw new UnsupportedOperationException();
    }

    public boolean isType(RelationshipType relationshipType) {
        throw new UnsupportedOperationException();
    }

    public GraphDatabaseService getGraphDatabase() {
        throw new UnsupportedOperationException();
    }

    public boolean hasProperty(String s) {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String s, Object o) {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String s, Object o) {
        throw new UnsupportedOperationException();
    }

    public Object removeProperty(String s) {
        throw new UnsupportedOperationException();
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ValueRelationship{id=" + this.id + ", startNode=" + this.startNode + ", endNode=" + this.endNode + ", type=" + this.type + ", props=" + this.getAllProperties() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueRelationship that = (ValueRelationship)o;
        if (this.endNode != that.endNode) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        return this.startNode == that.startNode && !(this.type == null ? that.type != null : !this.type.name().equals(that.type.name()));
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.startNode ^ this.startNode >>> 32);
        result = 31 * result + (int)(this.endNode ^ this.endNode >>> 32);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

