/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.infrastructure;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.infrastructure.UnboundRelationship;
import org.neo4j.bolt.v1.messaging.infrastructure.ValuePropertyContainer;
import org.neo4j.bolt.v1.messaging.infrastructure.ValueRelationship;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class ValueUnboundRelationship
extends ValuePropertyContainer
implements UnboundRelationship {
    private static final int STRUCT_FIELD_COUNT = 3;
    private final long id;
    private final RelationshipType type;

    public static void pack(Neo4jPack.Packer packer, Relationship rel) throws IOException {
        packer.packStructHeader(3, (byte)114);
        packer.pack(rel.getId());
        packer.pack(rel.getType().name());
        try {
            Map properties = rel.getAllProperties();
            packer.packRawMap(properties);
        }
        catch (NotFoundException e) {
            packer.packRawMap(Collections.emptyMap());
        }
    }

    public static ValueUnboundRelationship unpack(Neo4jPack.Unpacker unpacker) throws IOException {
        assert (unpacker.unpackStructHeader() == 3L);
        assert (unpacker.unpackStructSignature() == 'r');
        return ValueUnboundRelationship.unpackFields(unpacker);
    }

    public static ValueUnboundRelationship unpackFields(Neo4jPack.Unpacker unpacker) throws IOException {
        long relId = unpacker.unpackLong();
        String relTypeName = unpacker.unpackString();
        Map<String, Object> props = unpacker.unpackMap();
        RelationshipType relType = RelationshipType.withName((String)relTypeName);
        return new ValueUnboundRelationship(relId, relType, props);
    }

    public static ValueUnboundRelationship unbind(Relationship relationship) {
        Map props = relationship.getAllProperties();
        return new ValueUnboundRelationship(relationship.getId(), relationship.getType(), props);
    }

    public ValueUnboundRelationship(long id, RelationshipType type, Map<String, Object> props) {
        super(props);
        this.id = id;
        this.type = type;
    }

    public long getId() {
        return this.id;
    }

    public GraphDatabaseService getGraphDatabase() {
        throw new UnsupportedOperationException();
    }

    public boolean hasProperty(String key) {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String key, Object defaultValue) {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object removeProperty(String key) {
        throw new UnsupportedOperationException();
    }

    public RelationshipType getType() {
        return this.type;
    }

    public boolean isType(RelationshipType type) {
        return false;
    }

    public String toString() {
        return "ValueUnboundRelationship{id=" + this.id + ", type=" + this.type + ", props=" + this.getAllProperties() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValueUnboundRelationship)) {
            return false;
        }
        ValueUnboundRelationship that = (ValueUnboundRelationship)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.getAllProperties() != null ? !this.getAllProperties().equals(that.getAllProperties()) : that.getAllProperties() != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.getAllProperties() != null ? this.getAllProperties().hashCode() : 0);
        return result;
    }

    @Override
    public Relationship bind(Node startNode, Node endNode) {
        return new ValueRelationship(this.id, startNode.getId(), endNode.getId(), this.type, this.getAllProperties());
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public Node getStartNode() {
        return null;
    }

    public Node getEndNode() {
        return null;
    }

    public Node getOtherNode(Node node) {
        return null;
    }

    public Node[] getNodes() {
        return new Node[0];
    }
}

