/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

class ErrorReporter {
    private final Log userLog;
    private final Log debugLog;

    ErrorReporter(LogService logging) {
        this.userLog = logging.getUserLog(ErrorReporter.class);
        this.debugLog = logging.getInternalLog(ErrorReporter.class);
    }

    ErrorReporter(Log userLog, Log debugLog) {
        this.userLog = userLog;
        this.debugLog = debugLog;
    }

    public void report(Neo4jError error) {
        if (error.status().code().classification().shouldLog()) {
            this.userLog.error("Client triggered an unexpected error [%s]: %s. See debug.log for more details, reference %s.", new Object[]{error.status(), error.message(), error.reference()});
            this.debugLog.error(String.format("Client triggered an unexpected error [%s]: %s, reference %s.", error.status(), error.message(), error.reference()), error.cause());
        }
    }
}

