/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.v1.runtime.BoltFactory;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.v1.runtime.TransactionStateMachineSPI;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.udc.UsageData;

public class LifecycleManagedBoltFactory
extends LifecycleAdapter
implements BoltFactory {
    private final GraphDatabaseAPI gds;
    private final LifeSupport life = new LifeSupport();
    private final UsageData usageData;
    private final LogService logging;
    private final Authentication authentication;
    private final BoltConnectionTracker connectionTracker;
    private final ThreadToStatementContextBridge txBridge;
    private QueryExecutionEngine queryExecutionEngine;
    private GraphDatabaseQueryService queryService;
    private AvailabilityGuard availabilityGuard;

    public LifecycleManagedBoltFactory(GraphDatabaseAPI gds, UsageData usageData, LogService logging, ThreadToStatementContextBridge txBridge, Authentication authentication, BoltConnectionTracker connectionTracker) {
        this.gds = gds;
        this.usageData = usageData;
        this.logging = logging;
        this.txBridge = txBridge;
        this.authentication = authentication;
        this.connectionTracker = connectionTracker;
    }

    public void init() throws Throwable {
        this.life.init();
    }

    public void start() throws Throwable {
        DependencyResolver dependencyResolver = this.gds.getDependencyResolver();
        this.queryExecutionEngine = (QueryExecutionEngine)dependencyResolver.resolveDependency(QueryExecutionEngine.class);
        this.queryService = (GraphDatabaseQueryService)dependencyResolver.resolveDependency(GraphDatabaseQueryService.class);
        this.availabilityGuard = (AvailabilityGuard)dependencyResolver.resolveDependency(AvailabilityGuard.class);
        this.life.start();
    }

    public void stop() throws Throwable {
        this.life.stop();
    }

    public void shutdown() throws Throwable {
        this.life.shutdown();
    }

    @Override
    public BoltStateMachine newMachine(String connectionDescriptor, Runnable onClose, Clock clock) {
        TransactionStateMachineSPI transactionSPI = new TransactionStateMachineSPI(this.gds, this.txBridge, this.queryExecutionEngine, this.availabilityGuard, this.queryService, clock);
        BoltStateMachineSPI boltSPI = new BoltStateMachineSPI(connectionDescriptor, this.usageData, this.logging, this.authentication, this.connectionTracker, transactionSPI);
        return new BoltStateMachine(boltSPI, onClose, Clock.systemUTC());
    }
}

